/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.spi.messages.InternalPlcRequest;
import org.apache.plc4x.java.spi.messages.InternalPlcUnsubscriptionRequest;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.model.InternalPlcSubscriptionHandle;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class DefaultPlcUnsubscriptionRequest
implements InternalPlcUnsubscriptionRequest,
InternalPlcRequest {
    private final PlcSubscriber subscriber;
    private final Collection<? extends InternalPlcSubscriptionHandle> internalPlcSubscriptionHandles;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public DefaultPlcUnsubscriptionRequest(@JsonProperty(value="subscriber") PlcSubscriber subscriber, @JsonProperty(value="internalPlcSubscriptionHandles") Collection<? extends InternalPlcSubscriptionHandle> internalPlcSubscriptionHandles) {
        this.subscriber = subscriber;
        this.internalPlcSubscriptionHandles = internalPlcSubscriptionHandles;
    }

    @JsonIgnore
    public CompletableFuture<PlcUnsubscriptionResponse> execute() {
        return this.subscriber.unsubscribe(this);
    }

    public PlcSubscriber getSubscriber() {
        return this.subscriber;
    }

    @Override
    public Collection<? extends InternalPlcSubscriptionHandle> getInternalPlcSubscriptionHandles() {
        return this.internalPlcSubscriptionHandles;
    }

    public static class Builder
    implements PlcUnsubscriptionRequest.Builder {
        private final PlcSubscriber subscriber;
        private List<InternalPlcSubscriptionHandle> plcSubscriptionHandles;

        public Builder(PlcSubscriber subscriber) {
            this.subscriber = subscriber;
            this.plcSubscriptionHandles = new ArrayList<InternalPlcSubscriptionHandle>();
        }

        public PlcUnsubscriptionRequest.Builder addHandles(PlcSubscriptionHandle plcSubscriptionHandle) {
            this.plcSubscriptionHandles.add((InternalPlcSubscriptionHandle)plcSubscriptionHandle);
            return this;
        }

        public PlcUnsubscriptionRequest.Builder addHandles(PlcSubscriptionHandle plcSubscriptionHandle1, PlcSubscriptionHandle ... plcSubscriptionHandles) {
            this.plcSubscriptionHandles.add((InternalPlcSubscriptionHandle)plcSubscriptionHandle1);
            this.plcSubscriptionHandles.addAll(Arrays.stream(plcSubscriptionHandles).map(InternalPlcSubscriptionHandle.class::cast).collect(Collectors.toList()));
            return this;
        }

        public PlcUnsubscriptionRequest.Builder addHandles(Collection<PlcSubscriptionHandle> plcSubscriptionHandles) {
            this.plcSubscriptionHandles.addAll(plcSubscriptionHandles.stream().map(InternalPlcSubscriptionHandle.class::cast).collect(Collectors.toList()));
            return this;
        }

        public PlcUnsubscriptionRequest build() {
            return new DefaultPlcUnsubscriptionRequest(this.subscriber, this.plcSubscriptionHandles);
        }
    }
}

