/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.spi.connection.PlcFieldHandler;
import org.apache.plc4x.java.spi.messages.InternalPlcFieldRequest;
import org.apache.plc4x.java.spi.messages.InternalPlcReadRequest;
import org.apache.plc4x.java.spi.messages.PlcReader;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class DefaultPlcReadRequest
implements InternalPlcReadRequest,
InternalPlcFieldRequest {
    private final PlcReader reader;
    private LinkedHashMap<String, PlcField> fields;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public DefaultPlcReadRequest(@JsonProperty(value="reader") PlcReader reader, @JsonProperty(value="fields") LinkedHashMap<String, PlcField> fields) {
        this.reader = reader;
        this.fields = fields;
    }

    @JsonIgnore
    public CompletableFuture<PlcReadResponse> execute() {
        return this.reader.read(this);
    }

    @JsonIgnore
    public int getNumberOfFields() {
        return this.fields.size();
    }

    @JsonIgnore
    public LinkedHashSet<String> getFieldNames() {
        return new LinkedHashSet<String>(this.fields.keySet());
    }

    @JsonIgnore
    public PlcField getField(String name) {
        return this.fields.get(name);
    }

    @JsonIgnore
    public List<PlcField> getFields() {
        return new LinkedList<PlcField>(this.fields.values());
    }

    @Override
    @JsonIgnore
    public List<Pair<String, PlcField>> getNamedFields() {
        return this.fields.entrySet().stream().map(stringPlcFieldEntry -> Pair.of((Object)((String)stringPlcFieldEntry.getKey()), (Object)((PlcField)stringPlcFieldEntry.getValue()))).collect(Collectors.toCollection(LinkedList::new));
    }

    @JsonIgnore
    public PlcReader getReader() {
        return this.reader;
    }

    @JsonAnySetter
    public void add(String key, PlcField value) {
        this.fields.put(key, value);
    }

    @JsonAnyGetter
    public Map<String, PlcField> getMap() {
        return this.fields;
    }

    public static class Builder
    implements PlcReadRequest.Builder {
        private final PlcReader reader;
        private final PlcFieldHandler fieldHandler;
        private final Map<String, String> fields;

        public Builder(PlcReader reader, PlcFieldHandler fieldHandler) {
            this.reader = reader;
            this.fieldHandler = fieldHandler;
            this.fields = new TreeMap<String, String>();
        }

        public PlcReadRequest.Builder addItem(String name, String fieldQuery) {
            if (this.fields.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate field definition '" + name + "'");
            }
            this.fields.put(name, fieldQuery);
            return this;
        }

        public PlcReadRequest build() {
            LinkedHashMap<String, PlcField> parsedFields = new LinkedHashMap<String, PlcField>();
            this.fields.forEach((name, fieldQuery) -> {
                PlcField parsedField = this.fieldHandler.createField((String)fieldQuery);
                parsedFields.put((String)name, parsedField);
            });
            return new DefaultPlcReadRequest(this.reader, parsedFields);
        }
    }
}

