/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.generation;

import com.github.jinahya.bit.io.ArrayByteInput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.io.MyDefaultBitInput;

public class ReadBuffer {
    private final MyDefaultBitInput bi;
    private final boolean littleEndian;
    private final long totalBytes;

    public ReadBuffer(byte[] input) {
        this(input, false);
    }

    public ReadBuffer(byte[] input, boolean littleEndian) {
        ArrayByteInput abi = new ArrayByteInput(input);
        this.bi = new MyDefaultBitInput(abi);
        this.littleEndian = littleEndian;
        this.totalBytes = input.length;
    }

    public int getPos() {
        return (int)this.bi.getPos();
    }

    public byte[] getBytes(int startPos, int endPos) {
        int numBytes = endPos - startPos;
        byte[] data = new byte[numBytes];
        System.arraycopy(((ArrayByteInput)this.bi.getDelegate()).getSource(), startPos, data, 0, numBytes);
        return data;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public boolean hasMore(int numBits) {
        return (long)(numBits / 8) < this.totalBytes - (long)this.getPos();
    }

    public byte peekByte(int offset) throws ParseException {
        int oldIndex = ((ArrayByteInput)this.bi.getDelegate()).getIndex();
        try {
            ((ArrayByteInput)this.bi.getDelegate()).index(oldIndex + offset);
            byte by = this.bi.readByte(false, 8);
            return by;
        }
        catch (IOException e) {
            throw new ParseException("Error reading", e);
        }
        finally {
            ((ArrayByteInput)this.bi.getDelegate()).index(oldIndex);
        }
    }

    public boolean readBit() throws ParseException {
        try {
            return this.bi.readBoolean();
        }
        catch (IOException e) {
            throw new ParseException("Error reading", e);
        }
    }

    public byte readUnsignedByte(int bitLength) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned byte must contain at least 1 bit");
        }
        if (bitLength > 4) {
            throw new ParseException("unsigned byte can only contain max 4 bits");
        }
        try {
            return this.bi.readByte(true, bitLength);
        }
        catch (IOException e) {
            throw new ParseException("Error reading", e);
        }
    }

    public short readUnsignedShort(int bitLength) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned short must contain at least 1 bit");
        }
        if (bitLength > 8) {
            throw new ParseException("unsigned short can only contain max 8 bits");
        }
        try {
            return this.bi.readShort(true, bitLength);
        }
        catch (IOException e) {
            throw new ParseException("Error reading", e);
        }
    }

    public int readUnsignedInt(int bitLength) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned int must contain at least 1 bit");
        }
        if (bitLength > 16) {
            throw new ParseException("unsigned int can only contain max 16 bits");
        }
        try {
            if (this.littleEndian) {
                return Integer.reverseBytes(this.bi.readInt(true, bitLength)) >> 16 & 0xFFFF;
            }
            return this.bi.readInt(true, bitLength);
        }
        catch (IOException e) {
            throw new ParseException("Error reading", e);
        }
    }

    public long readUnsignedLong(int bitLength) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned long must contain at least 1 bit");
        }
        if (bitLength > 32) {
            throw new ParseException("unsigned long can only contain max 32 bits");
        }
        try {
            if (this.littleEndian) {
                return Long.reverseBytes(this.bi.readLong(true, bitLength)) >> 32;
            }
            return this.bi.readLong(true, bitLength);
        }
        catch (IOException e) {
            throw new ParseException("Error reading", e);
        }
    }

    public BigInteger readUnsignedBigInteger(int bitLength) throws ParseException {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public byte readByte(int bitLength) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("byte must contain at least 1 bit");
        }
        if (bitLength > 8) {
            throw new ParseException("byte can only contain max 8 bits");
        }
        try {
            return this.bi.readByte(false, bitLength);
        }
        catch (IOException e) {
            throw new ParseException("Error reading", e);
        }
    }

    public short readShort(int bitLength) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("short must contain at least 1 bit");
        }
        if (bitLength > 16) {
            throw new ParseException("short can only contain max 16 bits");
        }
        try {
            if (this.littleEndian) {
                return Short.reverseBytes(this.bi.readShort(false, bitLength));
            }
            return this.bi.readShort(false, bitLength);
        }
        catch (IOException e) {
            throw new ParseException("Error reading", e);
        }
    }

    public int readInt(int bitLength) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("int must contain at least 1 bit");
        }
        if (bitLength > 32) {
            throw new ParseException("int can only contain max 32 bits");
        }
        try {
            if (this.littleEndian) {
                return Integer.reverseBytes(this.bi.readInt(false, bitLength));
            }
            return this.bi.readInt(false, bitLength);
        }
        catch (IOException e) {
            throw new ParseException("Error reading", e);
        }
    }

    public long readLong(int bitLength) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("long must contain at least 1 bit");
        }
        if (bitLength > 64) {
            throw new ParseException("long can only contain max 64 bits");
        }
        try {
            if (this.littleEndian) {
                return Long.reverseBytes(this.bi.readLong(false, bitLength));
            }
            return this.bi.readLong(false, bitLength);
        }
        catch (IOException e) {
            throw new ParseException("Error reading", e);
        }
    }

    public BigInteger readBigInteger(int bitLength) throws ParseException {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public float readFloat(int bitLength) throws ParseException {
        try {
            if (bitLength == 16) {
                boolean sign = this.bi.readBoolean();
                byte exponent = this.bi.readByte(true, 5);
                short fraction = this.bi.readShort(true, 10);
                if (exponent >= 1 && exponent <= 30) {
                    return (float)((sign ? 1 : -1) * (2 ^ exponent - 15)) * (1.0f + (float)fraction / 10.0f);
                }
                if (exponent == 0) {
                    if (fraction == 0) {
                        return 0.0f;
                    }
                    return (float)((sign ? 1 : -1) * -16) * ((float)fraction / 10.0f);
                }
                if (exponent == 31) {
                    if (fraction == 0) {
                        return sign ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
                    }
                    return Float.NaN;
                }
                throw new NumberFormatException();
            }
            if (bitLength == 32) {
                byte[] buffer = new byte[]{this.bi.readByte(true, 8), this.bi.readByte(true, 8), this.bi.readByte(true, 8), this.bi.readByte(true, 8)};
                return Float.intBitsToFloat(buffer[0] & 0xFF ^ buffer[1] << 8 ^ buffer[2] << 16 ^ buffer[3] << 24);
            }
            throw new UnsupportedOperationException("unsupported bit length (only 16 and 32 supported)");
        }
        catch (IOException e) {
            throw new ParseException("Error reading", e);
        }
    }

    public double readDouble(int bitLength) throws ParseException {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public BigDecimal readBigDecimal(int bitLength) throws ParseException {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public String readString(int bitLength, String encoding) {
        byte[] strBytes = new byte[bitLength / 8];
        for (int i = 0; i < bitLength / 8 && this.hasMore(8); ++i) {
            try {
                strBytes[i] = this.readByte(8);
                continue;
            }
            catch (Exception e) {
                throw new PlcRuntimeException((Throwable)e);
            }
        }
        return new String(strBytes, Charset.forName(encoding));
    }
}

