/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.connection;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcIoException;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.configuration.ConfigurationFactory;
import org.apache.plc4x.java.spi.connection.AbstractPlcConnection;
import org.apache.plc4x.java.spi.connection.ChannelExposingConnection;
import org.apache.plc4x.java.spi.connection.ChannelFactory;
import org.apache.plc4x.java.spi.connection.PlcFieldHandler;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.events.CloseConnectionEvent;
import org.apache.plc4x.java.spi.events.ConnectEvent;
import org.apache.plc4x.java.spi.events.ConnectedEvent;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNettyPlcConnection
extends AbstractPlcConnection
implements ChannelExposingConnection {
    protected static final Timer timer = new HashedWheelTimer();
    private static final Logger logger = LoggerFactory.getLogger(DefaultNettyPlcConnection.class);
    protected final Configuration configuration;
    protected final ChannelFactory channelFactory;
    protected final boolean awaitSessionSetupComplete;
    protected final ProtocolStackConfigurer stackConfigurer;
    protected Channel channel;
    protected boolean connected;

    public DefaultNettyPlcConnection(boolean canRead, boolean canWrite, boolean canSubscribe, PlcFieldHandler fieldHandler, Configuration configuration, ChannelFactory channelFactory, boolean awaitSessionSetupComplete, ProtocolStackConfigurer stackConfigurer, BaseOptimizer optimizer) {
        super(canRead, canWrite, canSubscribe, fieldHandler, optimizer);
        this.configuration = configuration;
        this.channelFactory = channelFactory;
        this.awaitSessionSetupComplete = awaitSessionSetupComplete;
        this.stackConfigurer = stackConfigurer;
        this.connected = false;
    }

    public void connect() throws PlcConnectionException {
        try {
            CompletableFuture<Void> sessionSetupCompleteFuture = new CompletableFuture<Void>();
            if (this.channelFactory == null) {
                throw new PlcConnectionException("No channel factory provided");
            }
            ConfigurationFactory.configure(this.configuration, this.channelFactory);
            this.channel = this.channelFactory.createChannel(this.getChannelHandler(sessionSetupCompleteFuture));
            this.channel.closeFuture().addListener(future -> {
                if (!sessionSetupCompleteFuture.isDone()) {
                    sessionSetupCompleteFuture.completeExceptionally((Throwable)new PlcIoException("Connection terminated by remote"));
                }
            });
            this.sendChannelCreatedEvent();
            if (this.awaitSessionSetupComplete) {
                sessionSetupCompleteFuture.get();
            }
            this.connected = true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PlcConnectionException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new PlcConnectionException((Throwable)e);
        }
    }

    public void close() throws PlcConnectionException {
        this.channel.pipeline().fireUserEventTriggered((Object)new CloseConnectionEvent());
        this.channel.close().awaitUninterruptibly();
        this.channel = null;
        this.connected = false;
    }

    public boolean isConnected() {
        return this.connected && this.channel.isActive();
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    public ChannelHandler getChannelHandler(final CompletableFuture<Void> sessionSetupCompleteFuture) {
        if (this.stackConfigurer == null) {
            throw new IllegalStateException("No Protocol Stack Configurer is given!");
        }
        return new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt instanceof ConnectedEvent) {
                            sessionSetupCompleteFuture.complete(null);
                        } else {
                            super.userEventTriggered(ctx, evt);
                        }
                    }
                }});
                DefaultNettyPlcConnection.this.channelFactory.initializePipeline(pipeline);
                DefaultNettyPlcConnection.this.setProtocol(DefaultNettyPlcConnection.this.stackConfigurer.configurePipeline(DefaultNettyPlcConnection.this.configuration, pipeline));
            }
        };
    }

    protected void sendChannelCreatedEvent() {
        logger.trace("Channel was created, firing ChannelCreated Event");
        this.channel.pipeline().fireUserEventTriggered((Object)new ConnectEvent());
    }
}

