/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.MessageToMessageCodec;
import io.vavr.control.Either;
import java.time.Duration;
import java.time.Instant;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.events.CloseConnectionEvent;
import org.apache.plc4x.java.spi.events.ConnectEvent;
import org.apache.plc4x.java.spi.events.ConnectedEvent;
import org.apache.plc4x.java.spi.events.DisconnectEvent;
import org.apache.plc4x.java.spi.events.DisconnectedEvent;
import org.apache.plc4x.java.spi.internal.DefaultExpectRequestContext;
import org.apache.plc4x.java.spi.internal.DefaultSendRequestContext;
import org.apache.plc4x.java.spi.internal.HandlerRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plc4xNettyWrapper<T>
extends MessageToMessageCodec<T, Object> {
    private static final Logger logger = LoggerFactory.getLogger(Plc4xNettyWrapper.class);
    private final Plc4xProtocolBase<T> protocolBase;
    private final Queue<HandlerRegistration> registeredHandlers;
    private final ChannelPipeline pipeline;

    public Plc4xNettyWrapper(final ChannelPipeline pipeline, Plc4xProtocolBase<T> protocol, Class<T> clazz) {
        super(clazz, Object.class);
        this.pipeline = pipeline;
        this.registeredHandlers = new ConcurrentLinkedQueue<HandlerRegistration>();
        this.protocolBase = protocol;
        this.protocolBase.setContext(new ConversationContext<T>(){

            @Override
            public Channel getChannel() {
                return pipeline.channel();
            }

            @Override
            public void sendToWire(T msg) {
                pipeline.writeAndFlush(msg);
            }

            @Override
            public void fireConnected() {
                pipeline.fireUserEventTriggered(ConnectedEvent.class);
            }

            @Override
            public void fireDisconnected() {
                pipeline.fireUserEventTriggered(DisconnectedEvent.class);
            }

            @Override
            public ConversationContext.SendRequestContext<T> sendRequest(T packet) {
                return new DefaultSendRequestContext(handler -> {
                    logger.trace("Adding Response Handler ...");
                    Plc4xNettyWrapper.this.registeredHandlers.add(handler);
                }, packet, this);
            }

            @Override
            public ConversationContext.ExpectRequestContext<T> expectRequest(Class<T> clazz, Duration timeout) {
                return new DefaultExpectRequestContext(handler -> {
                    logger.trace("Adding Request Handler ...");
                    Plc4xNettyWrapper.this.registeredHandlers.add(handler);
                }, clazz, timeout, this);
            }
        });
    }

    protected void encode(ChannelHandlerContext channelHandlerContext, Object msg, List<Object> list) throws Exception {
        logger.debug("Forwarding request to plc {}", msg);
        list.add(msg);
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, T t, List<Object> list) throws Exception {
        logger.trace("Decoding {}", t);
        Iterator iter = this.registeredHandlers.iterator();
        block0: while (iter.hasNext()) {
            HandlerRegistration registration = (HandlerRegistration)iter.next();
            if (registration.isCancelled()) {
                logger.debug("Removing {} as it was cancelled!", (Object)registration);
                iter.remove();
                continue;
            }
            if (registration.getTimeout().isBefore(Instant.now())) {
                logger.debug("Removing {} as its timed out (was set till {})", (Object)registration, (Object)registration.getTimeout());
                iter.remove();
                continue;
            }
            logger.trace("Checking handler {} for Object of type {}", (Object)registration, (Object)t.getClass().getSimpleName());
            if (!registration.getExpectClazz().isInstance(t)) continue;
            logger.trace("Handler {} has right expected type {}, checking condition", (Object)registration, (Object)registration.getExpectClazz().getSimpleName());
            Deque<Either<Function<?, ?>, Predicate<?>>> commands = registration.getCommands();
            Object instance = t;
            for (Either<Function<?, ?>, Predicate<?>> either : commands) {
                if (either.isLeft()) {
                    Function unwrap = (Function)either.getLeft();
                    instance = unwrap.apply(instance);
                    continue;
                }
                Predicate predicate = (Predicate)either.get();
                if (predicate.test(instance)) continue;
                logger.trace("Registration {} does not match object {} (currently wrapped to {})", new Object[]{registration, t.getClass().getSimpleName(), instance.getClass().getSimpleName()});
                continue block0;
            }
            logger.trace("Handler {} accepts element {}, calling handle method", (Object)registration, t);
            this.registeredHandlers.remove(registration);
            Consumer<?> handler = registration.getPacketConsumer();
            handler.accept(instance);
            registration.confirmHandled();
            return;
        }
        logger.trace("No registered handler found for message {}, using default decode method", t);
        this.protocolBase.decode(new DefaultConversationContext(channelHandlerContext), t);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof ConnectEvent) {
            this.protocolBase.onConnect(new DefaultConversationContext(ctx));
        } else if (evt instanceof DisconnectEvent) {
            this.protocolBase.onDisconnect(new DefaultConversationContext(ctx));
        } else if (evt instanceof CloseConnectionEvent) {
            this.protocolBase.close(new DefaultConversationContext(ctx));
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public class DefaultConversationContext<T1>
    implements ConversationContext<T1> {
        private final ChannelHandlerContext channelHandlerContext;

        public DefaultConversationContext(ChannelHandlerContext channelHandlerContext) {
            this.channelHandlerContext = channelHandlerContext;
        }

        @Override
        public Channel getChannel() {
            return this.channelHandlerContext.channel();
        }

        @Override
        public void sendToWire(T1 msg) {
            logger.trace("Sending to wire {}", msg);
            this.channelHandlerContext.channel().writeAndFlush(msg);
        }

        @Override
        public void fireConnected() {
            logger.trace("Firing Connected!");
            this.channelHandlerContext.pipeline().fireUserEventTriggered((Object)new ConnectedEvent());
        }

        @Override
        public void fireDisconnected() {
            logger.trace("Firing Disconnected!");
            this.channelHandlerContext.pipeline().fireUserEventTriggered((Object)new DisconnectedEvent());
        }

        @Override
        public ConversationContext.SendRequestContext<T1> sendRequest(T1 packet) {
            return new DefaultSendRequestContext<T1>(handler -> {
                logger.trace("Adding Response Handler ...");
                Plc4xNettyWrapper.this.registeredHandlers.add(handler);
            }, packet, this);
        }

        @Override
        public ConversationContext.ExpectRequestContext<T1> expectRequest(Class<T1> clazz, Duration timeout) {
            return new DefaultExpectRequestContext<T1>(handler -> {
                logger.trace("Adding Request Handler ...");
                Plc4xNettyWrapper.this.registeredHandlers.add(handler);
            }, clazz, timeout, this);
        }
    }
}

