/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi;

import io.netty.channel.Channel;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;

public interface ConversationContext<T> {
    public Channel getChannel();

    public void sendToWire(T var1);

    public void fireConnected();

    public void fireDisconnected();

    public SendRequestContext<T> sendRequest(T var1);

    public ExpectRequestContext<T> expectRequest(Class<T> var1, Duration var2);

    public static interface ContextHandler {
        public boolean isDone();

        public void cancel();
    }

    public static class PlcWiringException
    extends PlcRuntimeException {
        public PlcWiringException(String message) {
            super(message);
        }
    }

    public static interface ExpectRequestContext<T> {
        public ExpectRequestContext<T> check(Predicate<T> var1);

        public ContextHandler handle(Consumer<T> var1);

        public ExpectRequestContext<T> onTimeout(Consumer<TimeoutException> var1);

        public <E extends Throwable> ExpectRequestContext<T> onError(BiConsumer<T, E> var1);

        public <R> ExpectRequestContext<R> unwrap(Function<T, R> var1);
    }

    public static interface SendRequestContext<T> {
        public SendRequestContext<T> expectResponse(Class<T> var1, Duration var2);

        public SendRequestContext<T> check(Predicate<T> var1);

        public ContextHandler handle(Consumer<T> var1);

        public SendRequestContext<T> onTimeout(Consumer<TimeoutException> var1);

        public <E extends Throwable> SendRequestContext<T> onError(BiConsumer<T, E> var1);

        public <R> SendRequestContext<R> unwrap(Function<T, R> var1);

        public <R> SendRequestContext<R> only(Class<R> var1);
    }
}

