/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcREAL
extends PlcIECValue<Float> {
    private static final String VALUE_OUT_OF_RANGE = "Value of type %s is out of range %f - %f for a %s Value";
    static final Float minValue = Float.valueOf(-3.4028235E38f);
    static final Float maxValue = Float.valueOf(Float.MAX_VALUE);

    public static PlcREAL of(Object value) {
        if (value instanceof Boolean) {
            return new PlcREAL((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcREAL((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcREAL((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcREAL((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcREAL(((Long)value).longValue());
        }
        if (value instanceof Float) {
            return new PlcREAL((Float)value);
        }
        if (value instanceof Double) {
            return new PlcREAL((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcREAL((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcREAL((BigDecimal)value);
        }
        return new PlcREAL((String)value);
    }

    public PlcREAL(Boolean value) {
        this.value = value != false ? Float.valueOf(1.0f) : Float.valueOf(0.0f);
        this.isNullable = false;
    }

    public PlcREAL(Byte value) {
        this.value = Float.valueOf(value.floatValue());
        this.isNullable = false;
    }

    public PlcREAL(Short value) {
        this.value = Float.valueOf(value.floatValue());
        this.isNullable = false;
    }

    public PlcREAL(Integer value) {
        this.value = Float.valueOf(value.floatValue());
        this.isNullable = false;
    }

    public PlcREAL(Float value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcREAL(Double value) {
        if (value < (double)minValue.floatValue() || value > (double)maxValue.floatValue()) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = Float.valueOf(value.floatValue());
        this.isNullable = false;
    }

    public PlcREAL(BigInteger value) {
        BigDecimal val = new BigDecimal(value);
        if (val.compareTo(BigDecimal.valueOf(minValue.floatValue())) < 0 || val.compareTo(BigDecimal.valueOf(maxValue.floatValue())) > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = Float.valueOf(val.floatValue());
        this.isNullable = true;
    }

    public PlcREAL(BigDecimal value) {
        if (value.compareTo(BigDecimal.valueOf(minValue.floatValue())) < 0 || value.compareTo(BigDecimal.valueOf(maxValue.floatValue())) > 0 || value.scale() > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = Float.valueOf(value.floatValue());
        this.isNullable = true;
    }

    public PlcREAL(String value) {
        try {
            this.value = Float.valueOf(Float.parseFloat(value.trim()));
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()), (Throwable)e);
        }
    }

    public PlcREAL(float value) {
        this.value = Float.valueOf(value);
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.REAL;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean getBoolean() {
        return this.value != null && !((Float)this.value).equals(Float.valueOf(0.0f));
    }

    @Override
    public boolean isByte() {
        return this.value != null && ((Float)this.value).floatValue() <= 127.0f && ((Float)this.value).floatValue() >= -128.0f;
    }

    @Override
    public byte getByte() {
        return ((Float)this.value).byteValue();
    }

    @Override
    public boolean isShort() {
        return this.value != null && ((Float)this.value).floatValue() <= 32767.0f && ((Float)this.value).floatValue() >= -32768.0f;
    }

    @Override
    public short getShort() {
        return ((Float)this.value).shortValue();
    }

    @Override
    public boolean isInteger() {
        return this.value != null && ((Float)this.value).floatValue() <= 2.1474836E9f && ((Float)this.value).floatValue() >= -2.1474836E9f;
    }

    @Override
    public int getInteger() {
        return ((Float)this.value).intValue();
    }

    @Override
    public boolean isLong() {
        return this.value != null && ((Float)this.value).floatValue() <= 9.223372E18f && ((Float)this.value).floatValue() >= -9.223372E18f;
    }

    @Override
    public long getLong() {
        return ((Float)this.value).longValue();
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.getLong());
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public float getFloat() {
        return ((Float)this.value).floatValue();
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public double getDouble() {
        return ((Float)this.value).doubleValue();
    }

    @Override
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.getDouble());
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return this.toString();
    }

    public String toString() {
        return Float.toString(((Float)this.value).floatValue());
    }

    @Override
    public byte[] getRaw() {
        return this.getBytes();
    }

    public byte[] getBytes() {
        int intBits = Float.floatToIntBits(((Float)this.value).floatValue());
        return new byte[]{(byte)(intBits >> 24), (byte)(intBits >> 16), (byte)(intBits >> 8), (byte)intBits};
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.writeDouble(this.getClass().getSimpleName(), 32, ((Float)this.value).floatValue(), new WithWriterArgs[0]);
    }
}

