/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.BitSet;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcBYTE
extends PlcIECValue<Short> {
    private static final String VALUE_OUT_OF_RANGE = "Value of type %s is out of range %d - %d for a %s Value";
    static final Short minValue = 0;
    static final Short maxValue = 255;

    public static PlcBYTE of(Object value) {
        if (value instanceof Boolean) {
            return new PlcBYTE((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcBYTE((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcBYTE((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcBYTE((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcBYTE((Long)value);
        }
        if (value instanceof Float) {
            return new PlcBYTE((Float)value);
        }
        if (value instanceof Double) {
            return new PlcBYTE((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcBYTE((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcBYTE((BigDecimal)value);
        }
        return new PlcBYTE((String)value);
    }

    public PlcBYTE(Boolean value) {
        this.value = value != false ? Short.valueOf((short)1) : Short.valueOf((short)0);
        this.isNullable = false;
    }

    public PlcBYTE(Byte value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcBYTE(Short value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value;
        this.isNullable = false;
    }

    public PlcBYTE(Integer value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcBYTE(Long value) {
        if (value < (long)minValue.shortValue() || value > (long)maxValue.shortValue()) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcBYTE(Float value) {
        if (value.floatValue() < (float)minValue.shortValue() || value.floatValue() > (float)maxValue.shortValue() || value.floatValue() % 1.0f != 0.0f) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcBYTE(Double value) {
        if (value < (double)minValue.shortValue() || value > (double)maxValue.shortValue() || value % 1.0 != 0.0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcBYTE(BigInteger value) {
        if (value.compareTo(BigInteger.valueOf(minValue.shortValue())) < 0 || value.compareTo(BigInteger.valueOf(maxValue.shortValue())) > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = true;
    }

    public PlcBYTE(BigDecimal value) {
        if (value.compareTo(BigDecimal.valueOf(minValue.shortValue())) < 0 || value.compareTo(BigDecimal.valueOf(maxValue.shortValue())) > 0 || value.scale() > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = true;
    }

    public PlcBYTE(String value) {
        try {
            short val = Short.parseShort(value.trim());
            if (val < minValue || val > maxValue) {
                throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
            }
            this.value = val;
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
    }

    public PlcBYTE(short value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value;
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.BYTE;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean getBoolean() {
        return this.value != null && !((Short)this.value).equals((short)0);
    }

    public boolean[] getBooleanArray() {
        boolean[] booleanValues = new boolean[8];
        BitSet bitSet = BitSet.valueOf(new long[]{((Short)this.value).shortValue()});
        int i = 0;
        while (i < 8) {
            booleanValues[i] = bitSet.get(i);
            ++i;
        }
        return booleanValues;
    }

    @Override
    public boolean isByte() {
        return this.value != null && (Short)this.value <= 127 && (Short)this.value >= -128;
    }

    @Override
    public byte getByte() {
        return ((Short)this.value).byteValue();
    }

    @Override
    public boolean isShort() {
        return true;
    }

    @Override
    public short getShort() {
        return (Short)this.value;
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public int getInteger() {
        return ((Short)this.value).intValue();
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public long getLong() {
        return ((Short)this.value).longValue();
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.getLong());
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public float getFloat() {
        return ((Short)this.value).floatValue();
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public double getDouble() {
        return ((Short)this.value).doubleValue();
    }

    @Override
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.getFloat());
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return this.toString();
    }

    public String toString() {
        return Short.toString((Short)this.value);
    }

    @Override
    public byte[] getRaw() {
        return this.getBytes();
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[]{(byte)((Short)this.value & 0xFF)};
        return bytes;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.writeShort(this.getClass().getSimpleName(), 8, (Short)this.value, new WithWriterArgs[0]);
    }
}

