/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.tag;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TagConfigParser {
    public static final Pattern TAG_CONFIG_PATTERN = Pattern.compile("(\\{(?<config>.*?)})?$");
    protected static final Pattern KEY_VALUE_PATTERN = Pattern.compile("(?<parameter>[\\w\\-_]+):\\s*(?<value>-?\\d+.\\d+|-?\\d+|\"[^\"]*\"|'[^']*'|true|false),?");

    private TagConfigParser() {
    }

    public static Map<String, String> parse(String tagAddress) {
        HashMap<String, String> params = new HashMap<String, String>();
        Matcher matcher = TAG_CONFIG_PATTERN.matcher(tagAddress);
        if (matcher.find() && matcher.group("config") != null) {
            Matcher kv = KEY_VALUE_PATTERN.matcher(matcher.group("config"));
            while (kv.find()) {
                params.put(kv.group("parameter"), TagConfigParser.clean(kv.group("value")));
            }
        }
        return params;
    }

    private static String clean(String value) {
        if (value.startsWith("'") && value.endsWith("'")) {
            return value.substring(1, value.length() - 1);
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }
}

