/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.connection;

import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcUnsupportedOperationException;
import org.apache.plc4x.java.api.messages.PlcBrowseRequest;
import org.apache.plc4x.java.api.messages.PlcBrowseRequestInterceptor;
import org.apache.plc4x.java.api.messages.PlcBrowseResponse;
import org.apache.plc4x.java.api.messages.PlcPingRequest;
import org.apache.plc4x.java.api.messages.PlcPingResponse;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.metadata.PlcConnectionMetadata;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.messages.DefaultPlcBrowseRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcUnsubscriptionRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.PlcBrowser;
import org.apache.plc4x.java.spi.messages.PlcPinger;
import org.apache.plc4x.java.spi.messages.PlcReader;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.PlcWriter;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPlcConnection
implements PlcConnection,
PlcConnectionMetadata,
PlcPinger,
PlcReader,
PlcWriter,
PlcSubscriber,
PlcBrowser {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractPlcConnection.class);
    private boolean canPing = false;
    private boolean canRead = false;
    private boolean canWrite = false;
    private boolean canSubscribe = false;
    private boolean canBrowse = false;
    private PlcTagHandler tagHandler;
    private PlcValueHandler valueHandler;
    private Plc4xProtocolBase<? extends Message> protocol;
    private BaseOptimizer optimizer;
    private PlcAuthentication authentication;

    @Deprecated
    protected AbstractPlcConnection() {
    }

    protected AbstractPlcConnection(boolean canPing, boolean canRead, boolean canWrite, boolean canSubscribe, boolean canBrowse, PlcTagHandler tagHandler, PlcValueHandler valueHandler, BaseOptimizer optimizer, PlcAuthentication authentication) {
        this.canPing = canPing;
        this.canRead = canRead;
        this.canWrite = canWrite;
        this.canSubscribe = canSubscribe;
        this.canBrowse = canBrowse;
        this.tagHandler = tagHandler;
        this.valueHandler = valueHandler;
        this.optimizer = optimizer;
        this.authentication = authentication;
    }

    public void setProtocol(Plc4xProtocolBase<? extends Message> protocol) {
        this.protocol = protocol;
    }

    public Plc4xProtocolBase<? extends Message> getProtocol() {
        return this.protocol;
    }

    public PlcConnectionMetadata getMetadata() {
        return this;
    }

    public CompletableFuture<? extends PlcPingResponse> ping() {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally((Throwable)new PlcUnsupportedOperationException("The connection does not support pinging"));
        return future;
    }

    public boolean isReadSupported() {
        return this.canRead;
    }

    public boolean isWriteSupported() {
        return this.canWrite;
    }

    public boolean isSubscribeSupported() {
        return this.canSubscribe;
    }

    public boolean isBrowseSupported() {
        return this.canBrowse;
    }

    public PlcTagHandler getPlcTagHandler() {
        return this.tagHandler;
    }

    public PlcValueHandler getPlcValueHandler() {
        return this.valueHandler;
    }

    protected PlcAuthentication getAuthentication() {
        return this.authentication;
    }

    public PlcReadRequest.Builder readRequestBuilder() {
        if (!this.isReadSupported()) {
            throw new PlcUnsupportedOperationException("The connection does not support reading");
        }
        return new DefaultPlcReadRequest.Builder(this, this.getPlcTagHandler());
    }

    public PlcWriteRequest.Builder writeRequestBuilder() {
        if (!this.isWriteSupported()) {
            throw new PlcUnsupportedOperationException("The connection does not support writing");
        }
        return new DefaultPlcWriteRequest.Builder(this, this.getPlcTagHandler(), this.getPlcValueHandler());
    }

    public PlcSubscriptionRequest.Builder subscriptionRequestBuilder() {
        if (!this.isSubscribeSupported()) {
            throw new PlcUnsupportedOperationException("The connection does not support subscription");
        }
        return new DefaultPlcSubscriptionRequest.Builder(this, this.getPlcTagHandler());
    }

    public PlcUnsubscriptionRequest.Builder unsubscriptionRequestBuilder() {
        if (!this.canSubscribe) {
            throw new PlcUnsupportedOperationException("The connection does not support subscription");
        }
        return new DefaultPlcUnsubscriptionRequest.Builder(this);
    }

    public PlcBrowseRequest.Builder browseRequestBuilder() {
        if (!this.canBrowse) {
            throw new PlcUnsupportedOperationException("The connection does not support browsing");
        }
        return new DefaultPlcBrowseRequest.Builder(this, this.getPlcTagHandler());
    }

    @Override
    public CompletableFuture<PlcPingResponse> ping(PlcPingRequest pingRequest) {
        if (!this.canPing) {
            throw new PlcUnsupportedOperationException("The connection does not support pinging");
        }
        return this.protocol.ping(pingRequest);
    }

    @Override
    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        if (this.optimizer != null) {
            return this.optimizer.optimizedRead(readRequest, this.protocol);
        }
        return this.protocol.read(readRequest);
    }

    @Override
    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        if (this.optimizer != null) {
            return this.optimizer.optimizedWrite(writeRequest, this.protocol);
        }
        return this.protocol.write(writeRequest);
    }

    @Override
    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        if (this.optimizer != null) {
            return this.optimizer.optimizedSubscribe(subscriptionRequest, this.protocol);
        }
        return this.protocol.subscribe(subscriptionRequest);
    }

    @Override
    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        if (this.optimizer != null) {
            return this.optimizer.optimizedUnsubscribe(unsubscriptionRequest, this.protocol);
        }
        return this.protocol.unsubscribe(unsubscriptionRequest);
    }

    @Override
    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> handles) {
        throw new NotImplementedException("");
    }

    @Override
    public void unregister(PlcConsumerRegistration registration) {
        throw new NotImplementedException("");
    }

    @Override
    public CompletableFuture<PlcBrowseResponse> browse(PlcBrowseRequest browseRequest) {
        return this.protocol.browse(browseRequest);
    }

    @Override
    public CompletableFuture<PlcBrowseResponse> browseWithInterceptor(PlcBrowseRequest browseRequest, PlcBrowseRequestInterceptor interceptor) {
        return this.protocol.browseWithInterceptor(browseRequest, interceptor);
    }

    public Optional<PlcTag> parseTagAddress(String tagAddress) {
        PlcTag plcTag;
        try {
            plcTag = this.tagHandler.parseTag(tagAddress);
        }
        catch (Exception e) {
            logger.error("Error parsing tag address {}", (Object)tagAddress);
            return Optional.empty();
        }
        return Optional.ofNullable(plcTag);
    }
}

