/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.scraper.triggeredscraper.triggerhandler;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.PlcDriverManager;
import org.apache.plc4x.java.api.PlcDriver;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.scraper.exception.ScraperConfigurationException;
import org.apache.plc4x.java.scraper.exception.ScraperException;
import org.apache.plc4x.java.scraper.triggeredscraper.TriggeredScrapeJobImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(TriggerConfiguration.class);
    private static final String TRIGGER = "TRIGGER_VAR";
    private static final String SCHEDULED = "SCHEDULED";
    private static final String PREVIOUS_DEF = "PREV";
    private static final double TOLERANCE_FLOATING_EQUALITY = 1.0E-6;
    private static final Pattern TRIGGER_STRATEGY_PATTERN = Pattern.compile("\\((?<strategy>[A-Z_0-9]+),(?<scheduledInterval>\\d+)(,(\\((?<triggerVar>[^!=<>()]+)\\))((?<comp>[!=<>]{1,2}))(\\((?<compVar>[PREVa-z0-9.\\-]+)\\))((?<concatConn>[ANDOR]{2,3})(\\((?<triggerVar2>[^!=<>()]+)\\))((?<comp2>[!=<>]{1,2}))(\\((?<compVar2>[PREVa-z0-9.\\-]+)\\)))?)?\\)");
    private final TriggerType triggerType;
    private final Long scrapeInterval;
    private TriggeredScrapeJobImpl triggeredScrapeJobImpl;
    private List<TriggerElement> triggerElementList;

    public TriggerConfiguration(TriggerType triggerType, String scrapeInterval, List<TriggerElement> triggerElementList, TriggeredScrapeJobImpl triggeredScrapeJobImpl) throws ScraperConfigurationException {
        this.triggerElementList = triggerElementList;
        this.triggerType = triggerType;
        this.triggeredScrapeJobImpl = triggeredScrapeJobImpl;
        this.scrapeInterval = this.parseScrapeInterval(scrapeInterval);
        if (this.triggerType.equals((Object)TriggerType.TRIGGER_VAR)) {
            if (this.triggerElementList.isEmpty()) {
                String exceptionMessage = String.format("No items in trigger List for trigger-type TRIGGER_VAR for Job %s!", triggeredScrapeJobImpl.getJobName());
                throw new ScraperConfigurationException(exceptionMessage);
            }
        } else {
            String exceptionMessage = String.format("TriggerType %s is not yet implemented", new Object[]{this.triggerType});
            throw new ScraperConfigurationException(exceptionMessage);
        }
        this.checkTriggerVarList();
    }

    public TriggerConfiguration(TriggerType triggerType, String scrapeInterval) throws ScraperConfigurationException {
        this.triggerType = triggerType;
        this.scrapeInterval = this.parseScrapeInterval(scrapeInterval);
        this.triggerElementList = new ArrayList<TriggerElement>();
    }

    private void checkTriggerVarList() throws ScraperConfigurationException {
        boolean first = true;
        for (TriggerElement triggerElement : this.triggerElementList) {
            if (!first && triggerElement.getConcatType() == null) {
                throw new ScraperConfigurationException("A concat for the second and following trigger must be given!");
            }
            first = false;
        }
    }

    private long parseScrapeInterval(String scrapeInterval) throws ScraperConfigurationException {
        try {
            return Long.parseLong(scrapeInterval);
        }
        catch (Exception e) {
            this.handleException(e);
            String exceptionMessage = String.format("No valid numeric for scrapeInterval for Job %s: %s", this.triggeredScrapeJobImpl.getJobName(), scrapeInterval);
            throw new ScraperConfigurationException(exceptionMessage);
        }
    }

    boolean evaluateTrigger(List<Object> acquiredValues) throws ScraperException {
        TriggerEvaluation triggerEvaluation = new TriggerEvaluation(acquiredValues, this.triggerElementList);
        return triggerEvaluation.evaluateTrigger();
    }

    private static Class<?> validateDataType(PlcField plcField) throws ScraperConfigurationException {
        if (plcField != null) {
            Class javaDataType = plcField.getDefaultJavaType();
            if (!(javaDataType.equals(Boolean.class) || javaDataType.equals(Integer.class) || javaDataType.equals(Long.class) || javaDataType.equals(Double.class))) {
                String exceptionMessage = String.format("Unsupported plc-trigger variable %s with converted data-type %s used", plcField, plcField.getDefaultJavaType());
                throw new ScraperConfigurationException(exceptionMessage);
            }
            return javaDataType;
        }
        String exceptionMessage = "Null plc-trigger variable used";
        throw new ScraperConfigurationException(exceptionMessage);
    }

    public static TriggerConfiguration createConfiguration(String jobTriggerStrategy, TriggeredScrapeJobImpl triggeredScrapeJob) throws ScraperConfigurationException {
        Matcher matcher = TRIGGER_STRATEGY_PATTERN.matcher(jobTriggerStrategy);
        if (matcher.matches()) {
            String triggerStrategy = matcher.group("strategy");
            String scheduledMs = matcher.group("scheduledInterval");
            if (logger.isDebugEnabled()) {
                logger.debug("Strategy: {}, scheduled ms: {}", (Object)triggerStrategy, (Object)scheduledMs);
            }
            String triggerVar = matcher.group("triggerVar");
            String comparatorString = matcher.group("comp");
            String comparatorVariable = matcher.group("compVar");
            switch (triggerStrategy) {
                case "TRIGGER_VAR": {
                    if (triggerVar == null || comparatorString == null || comparatorVariable == null) {
                        throw new ScraperConfigurationException("TRIGGER_VAR trigger strategy needs the trigger-condition - information missing! given configString: " + jobTriggerStrategy);
                    }
                    ArrayList<TriggerElement> triggerElements = new ArrayList<TriggerElement>();
                    String connectionString = triggeredScrapeJob.getSourceConnections().get(triggeredScrapeJob.getSourceConnections().keySet().iterator().next());
                    TriggerElement triggerElement = new TriggerElement(comparatorString, null, comparatorVariable, triggerVar, triggerStrategy, connectionString);
                    triggerElement.setTriggerJob(triggeredScrapeJob.getJobName());
                    triggerElements.add(triggerElement);
                    String concatConn = matcher.group("concatConn");
                    String triggerVar2 = matcher.group("triggerVar2");
                    String comparatorString2 = matcher.group("comp2");
                    String comparatorVariable2 = matcher.group("compVar2");
                    if (triggerVar2 != null && comparatorString2 != null && comparatorVariable2 != null && concatConn != null) {
                        TriggerElement triggerElement2 = new TriggerElement(comparatorString2, concatConn, comparatorVariable2, triggerVar2, triggerStrategy, connectionString);
                        triggerElement2.setTriggerJob(triggeredScrapeJob.getJobName());
                        triggerElements.add(triggerElement2);
                    }
                    return new TriggerConfiguration(TriggerType.TRIGGER_VAR, scheduledMs, triggerElements, triggeredScrapeJob);
                }
                case "SCHEDULED": {
                    if (triggerVar != null || comparatorString != null || comparatorVariable != null) {
                        throw new ScraperConfigurationException("SCHEDULED trigger strategy must only be used with scheduled interval - nothing more!  given configString: " + jobTriggerStrategy);
                    }
                    return new TriggerConfiguration(TriggerType.SCHEDULED, scheduledMs);
                }
            }
            throw new ScraperConfigurationException("Unknown Trigger Strategy " + triggerStrategy);
        }
        throw new ScraperConfigurationException("Invalid trigger strategy string description: " + jobTriggerStrategy);
    }

    private void handleException(Exception e) {
        if (logger.isDebugEnabled()) {
            logger.debug("Exception: ", (Throwable)e);
        }
    }

    TriggerType getTriggerType() {
        return this.triggerType;
    }

    public long getScrapeInterval() {
        return this.scrapeInterval;
    }

    public List<TriggerElement> getTriggerElementList() {
        return this.triggerElementList;
    }

    private static boolean isApproximately(double self, double other, double within) {
        return Math.abs(self - other) <= within;
    }

    public static class TriggerElement {
        private Comparator comparatorType;
        private ConcatType concatType;
        private Boolean previousMode;
        private Object compareValue;
        private PlcField plcField;
        private String plcFieldString;
        private String plcConnectionString;
        private String uuid;
        private String triggerJob;
        private Object reservedCompareValue;

        public TriggerElement() {
            this.comparatorType = null;
            this.concatType = null;
            this.previousMode = false;
            this.compareValue = null;
            this.plcField = null;
            this.plcFieldString = null;
            this.reservedCompareValue = null;
            this.plcConnectionString = "not defined";
            this.triggerJob = "Not yet defined";
            this.uuid = "";
        }

        public TriggerElement(Comparator comparatorType, ConcatType concatType, Boolean previousMode, Object compareValue, PlcField plcField, String plcFieldString) {
            this.comparatorType = comparatorType;
            this.concatType = concatType;
            this.previousMode = previousMode;
            this.compareValue = compareValue;
            this.plcField = plcField;
            this.plcFieldString = plcFieldString;
        }

        public TriggerElement(Comparator comparatorType, Object compareValue, PlcField plcField) {
            this();
            this.comparatorType = comparatorType;
            this.compareValue = compareValue;
            this.plcField = plcField;
        }

        TriggerElement(String comparator, String concatType, String compareValue, String plcField, String triggerStrategy, String plcConnectionString) throws ScraperConfigurationException {
            this();
            this.plcFieldString = plcField;
            this.plcConnectionString = plcConnectionString;
            if (triggerStrategy.equals(TriggerConfiguration.TRIGGER)) {
                try {
                    this.plcField = this.prepareField(this.plcFieldString);
                }
                catch (Exception e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Exception occurred parsing a PlcField");
                    }
                    throw new ScraperConfigurationException("Exception on parsing S7Field (" + plcField + "): " + e.getMessage());
                }
                this.compareValue = this.convertCompareValue(compareValue, this.plcField);
                this.comparatorType = this.detectComparatorType(comparator);
                this.matchTypeAndComparator();
            }
            this.concatType = this.detectConcatType(concatType);
        }

        private PlcField prepareField(String fieldQuery) throws PlcConnectionException {
            PlcDriverManager driverManager = new PlcDriverManager();
            PlcDriver driver = driverManager.getDriver(this.plcConnectionString);
            return driver.prepareField(fieldQuery);
        }

        private Object convertCompareValue(String compareValue, PlcField plcField) throws ScraperConfigurationException {
            Class javaDataType = TriggerConfiguration.validateDataType(plcField);
            if (javaDataType.equals(Boolean.class)) {
                switch (compareValue) {
                    case "1": 
                    case "true": {
                        return true;
                    }
                    case "0": 
                    case "false": {
                        return false;
                    }
                }
                String exceptionMessage = String.format("No valid compare Value at DataType Boolean for trigger: %s", compareValue);
                throw new ScraperConfigurationException(exceptionMessage);
            }
            if (javaDataType.equals(Double.class) || javaDataType.equals(Integer.class) || javaDataType.equals(Long.class)) {
                try {
                    if (TriggerConfiguration.PREVIOUS_DEF.equals(compareValue)) {
                        this.previousMode = true;
                        return null;
                    }
                    return Double.parseDouble(compareValue);
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                    String exceptionMessage = String.format("No valid compare Value at DataType Numeric for trigger: %s", compareValue);
                    throw new ScraperConfigurationException(exceptionMessage);
                }
            }
            String exceptionMessage = "Invalid Datatype detected ... should not happen and be catcht earlier - please report";
            throw new ScraperConfigurationException(exceptionMessage);
        }

        private Comparator detectComparatorType(String comparator) throws ScraperConfigurationException {
            switch (comparator) {
                case "==": {
                    return Comparator.EQUAL;
                }
                case "!=": {
                    return Comparator.UNEQUAL;
                }
                case "<=": {
                    return Comparator.SMALLER_EQUAL;
                }
                case "<": {
                    return Comparator.SMALLER;
                }
                case ">=": {
                    return Comparator.GREATER_EQUAL;
                }
                case ">": {
                    return Comparator.GREATER;
                }
            }
            throw new ScraperConfigurationException("Invalid comparator detected!");
        }

        private ConcatType detectConcatType(String concat) throws ScraperConfigurationException {
            if (concat == null) {
                return null;
            }
            switch (concat) {
                case "AND": {
                    return ConcatType.AND;
                }
                case "OR": {
                    return ConcatType.OR;
                }
            }
            throw new ScraperConfigurationException("Invalid concat between triggerVars detected: " + concat);
        }

        private void matchTypeAndComparator() throws ScraperConfigurationException {
            if (TriggerConfiguration.validateDataType(this.plcField).equals(Boolean.class) && !this.comparatorType.equals((Object)Comparator.EQUAL) && !this.comparatorType.equals((Object)Comparator.UNEQUAL)) {
                String exceptionMessage = String.format("Trigger-Data-Type (%s) and Comparator (%s) do not match", new Object[]{this.plcField.getDefaultJavaType(), this.comparatorType});
                throw new ScraperConfigurationException(exceptionMessage);
            }
        }

        Comparator getComparatorType() {
            return this.comparatorType;
        }

        ConcatType getConcatType() {
            return this.concatType;
        }

        Boolean getPreviousMode() {
            return this.previousMode;
        }

        Object getCompareValue() {
            return this.compareValue;
        }

        PlcField getPlcField() {
            return this.plcField;
        }

        String getPlcFieldString() {
            return this.plcFieldString;
        }

        void setCompareValue(Object compareValue) {
            this.compareValue = compareValue;
        }

        Object getReservedCompareValue() {
            return this.reservedCompareValue;
        }

        void setReservedCompareValue(Object reservedCompareValue) {
            this.reservedCompareValue = reservedCompareValue;
        }

        String getTriggerJob() {
            return this.triggerJob;
        }

        void setTriggerJob(String triggerJob) {
            this.triggerJob = triggerJob;
        }

        void overrideCompareValue() {
            if (this.previousMode.booleanValue() && this.reservedCompareValue != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Compare value overridden, before: {}, now: {}; for Trigger {}", new Object[]{this.compareValue, this.reservedCompareValue, this.triggerJob});
                }
                this.compareValue = this.reservedCompareValue;
            }
        }

        public String getPlcConnectionString() {
            return this.plcConnectionString;
        }

        public void setPlcConnectionString(String plcConnectionString) {
            this.plcConnectionString = plcConnectionString;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }
    }

    public static enum ConcatType {
        AND,
        OR;

    }

    public static enum TriggerType {
        SCHEDULED,
        S7_TRIGGER_VAR,
        TRIGGER_VAR;

    }

    public static enum Comparator {
        EQUAL,
        UNEQUAL,
        GREATER,
        GREATER_EQUAL,
        SMALLER,
        SMALLER_EQUAL;

    }

    class TriggerEvaluation {
        private List<Object> acquiredValuesList;
        private List<TriggerElement> triggerElementList;

        TriggerEvaluation(List<Object> acquiredValuesList, List<TriggerElement> triggerElementList) {
            this.acquiredValuesList = acquiredValuesList;
            this.triggerElementList = triggerElementList;
        }

        boolean evaluateTrigger() throws ScraperException {
            ArrayList<Boolean> triggerResultList = new ArrayList<Boolean>();
            if (logger.isTraceEnabled()) {
                String connString = "empty";
                if (!this.triggerElementList.isEmpty()) {
                    connString = this.triggerElementList.get(0).getPlcConnectionString();
                }
                logger.trace("eval values for job {} and {}: {}", new Object[]{TriggerConfiguration.this.triggeredScrapeJobImpl.getJobName(), connString, this.acquiredValuesList});
            }
            for (int countElements = 0; countElements < this.acquiredValuesList.size(); ++countElements) {
                double currentValue;
                TriggerElement triggerElement = this.triggerElementList.get(countElements);
                Object acquiredObject = this.acquiredValuesList.get(countElements);
                if (TriggerConfiguration.validateDataType(triggerElement.getPlcField()).equals(Boolean.class)) {
                    boolean refValue;
                    boolean currentValue2;
                    try {
                        currentValue2 = (Boolean)acquiredObject;
                        refValue = (Boolean)triggerElement.getCompareValue();
                    }
                    catch (Exception e) {
                        TriggerConfiguration.this.handleException(e);
                        return false;
                    }
                    if (triggerElement.getComparatorType().equals((Object)Comparator.EQUAL)) {
                        triggerResultList.add(currentValue2 == refValue);
                    } else {
                        triggerResultList.add(currentValue2 != refValue);
                    }
                }
                if (!TriggerConfiguration.validateDataType(triggerElement.getPlcField()).equals(Double.class) && !TriggerConfiguration.validateDataType(triggerElement.getPlcField()).equals(Integer.class) && !TriggerConfiguration.validateDataType(triggerElement.getPlcField()).equals(Long.class)) continue;
                boolean skipComparison = false;
                double refValue = 0.0;
                try {
                    currentValue = acquiredObject instanceof Short ? ((Short)acquiredObject).doubleValue() : (acquiredObject instanceof Integer ? ((Integer)acquiredObject).doubleValue() : (acquiredObject instanceof Long ? ((Long)acquiredObject).doubleValue() : (acquiredObject instanceof Double ? ((Double)acquiredObject).doubleValue() : ((Double)acquiredObject).doubleValue())));
                    if (triggerElement.getPreviousMode().booleanValue()) {
                        if (triggerElement.getCompareValue() == null) {
                            triggerElement.setCompareValue(currentValue);
                            triggerElement.setReservedCompareValue(currentValue);
                            triggerResultList.add(true);
                            if (logger.isTraceEnabled()) {
                                logger.trace("Initially set compare value to {}", (Object)currentValue);
                            }
                            skipComparison = true;
                        } else {
                            refValue = (Double)triggerElement.getCompareValue();
                        }
                    } else {
                        refValue = (Double)triggerElement.getCompareValue();
                    }
                }
                catch (Exception e) {
                    TriggerConfiguration.this.handleException(e);
                    return false;
                }
                boolean triggerResult = false;
                if (!skipComparison) {
                    switch (triggerElement.getComparatorType()) {
                        case EQUAL: {
                            triggerResult = TriggerConfiguration.isApproximately(currentValue, refValue, 1.0E-6);
                            break;
                        }
                        case UNEQUAL: {
                            triggerResult = !TriggerConfiguration.isApproximately(currentValue, refValue, 1.0E-6);
                            break;
                        }
                        case SMALLER: {
                            triggerResult = currentValue < refValue;
                            break;
                        }
                        case SMALLER_EQUAL: {
                            triggerResult = currentValue <= refValue;
                            break;
                        }
                        case GREATER: {
                            triggerResult = currentValue > refValue;
                            break;
                        }
                        case GREATER_EQUAL: {
                            triggerResult = currentValue >= refValue;
                            break;
                        }
                        default: {
                            triggerResult = false;
                        }
                    }
                }
                if (triggerResult && triggerElement.getPreviousMode().booleanValue()) {
                    triggerElement.setReservedCompareValue(currentValue);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Subcondition matched. Previous value: {}, current compare value {} for Job {}", new Object[]{triggerElement.getReservedCompareValue(), triggerElement.getCompareValue(), triggerElement.getTriggerJob()});
                    }
                }
                triggerResultList.add(triggerResult);
            }
            if (triggerResultList.isEmpty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No results could be acquired - setting trigger to false");
                }
                return false;
            }
            if (triggerResultList.size() > 1) {
                if (logger.isTraceEnabled()) {
                    logger.trace("{}", triggerResultList);
                }
                boolean combinedResult = (Boolean)triggerResultList.get(0);
                block17: for (int countElements = 1; countElements < this.acquiredValuesList.size(); ++countElements) {
                    switch (this.triggerElementList.get(countElements).getConcatType()) {
                        case AND: {
                            combinedResult = combinedResult && (Boolean)triggerResultList.get(countElements) != false;
                            continue block17;
                        }
                        case OR: {
                            combinedResult = combinedResult || (Boolean)triggerResultList.get(countElements) != false;
                            continue block17;
                        }
                        default: {
                            combinedResult = false;
                        }
                    }
                }
                if (combinedResult) {
                    this.triggerElementList.forEach(TriggerElement::overrideCompareValue);
                }
                return combinedResult;
            }
            if (((Boolean)triggerResultList.get(0)).booleanValue()) {
                this.triggerElementList.forEach(TriggerElement::overrideCompareValue);
            }
            return (Boolean)triggerResultList.get(0);
        }
    }
}

