/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.scraper.triggeredscraper;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.plc4x.java.PlcDriverManager;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.scraper.ResultHandler;
import org.apache.plc4x.java.scraper.ScrapeJob;
import org.apache.plc4x.java.scraper.Scraper;
import org.apache.plc4x.java.scraper.ScraperTask;
import org.apache.plc4x.java.scraper.config.ScraperConfiguration;
import org.apache.plc4x.java.scraper.config.triggeredscraper.ScraperConfigurationTriggeredImpl;
import org.apache.plc4x.java.scraper.exception.ScraperException;
import org.apache.plc4x.java.scraper.triggeredscraper.TriggeredScrapeJobImpl;
import org.apache.plc4x.java.scraper.triggeredscraper.TriggeredScraperMBean;
import org.apache.plc4x.java.scraper.triggeredscraper.TriggeredScraperTask;
import org.apache.plc4x.java.scraper.triggeredscraper.triggerhandler.collector.TriggerCollector;
import org.apache.plc4x.java.scraper.util.PercentageAboveThreshold;
import org.apache.plc4x.java.utils.connectionpool.PooledPlcDriverManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggeredScraperImpl
implements Scraper,
TriggeredScraperMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggeredScraperImpl.class);
    private static final String MX_DOMAIN = "org.apache.plc4x.java";
    private static final int DEFAULT_FUTURE_TIME_OUT = 2000;
    private final ScheduledExecutorService scheduler;
    private final ExecutorService executorService;
    private ScheduledFuture<?> statisticsLogger;
    private final ResultHandler resultHandler;
    private final MultiValuedMap<ScrapeJob, ScraperTask> tasks = new ArrayListValuedHashMap();
    private final MultiValuedMap<ScraperTask, ScheduledFuture<?>> scraperTaskMap = new ArrayListValuedHashMap();
    private final PlcDriverManager driverManager;
    private final List<ScrapeJob> jobs;
    private MBeanServer mBeanServer;
    private long futureTimeOut;
    private final TriggerCollector triggerCollector;

    public TriggeredScraperImpl(ScraperConfiguration config, ResultHandler resultHandler, TriggerCollector triggerCollector) throws ScraperException {
        this(resultHandler, (PlcDriverManager)TriggeredScraperImpl.createPooledDriverManager(), config.getJobs(), triggerCollector, 2000L);
    }

    public TriggeredScraperImpl(ScraperConfiguration config, PlcDriverManager plcDriverManager, ResultHandler resultHandler, TriggerCollector triggerCollector) throws ScraperException {
        this(resultHandler, plcDriverManager, config.getJobs(), triggerCollector, 2000L);
    }

    public TriggeredScraperImpl(ScraperConfigurationTriggeredImpl config, PlcDriverManager plcDriverManager, ResultHandler resultHandler, TriggerCollector triggerCollector, int poolSizeScheduler, int poolSizeExecutor) throws ScraperException {
        this(resultHandler, plcDriverManager, config.getJobs(), triggerCollector, 2000L, poolSizeScheduler, poolSizeExecutor);
    }

    public TriggeredScraperImpl(ResultHandler resultHandler, PlcDriverManager plcDriverManager, List<ScrapeJob> jobs, TriggerCollector triggerCollector, long futureTimeOut) {
        this(resultHandler, plcDriverManager, jobs, triggerCollector, futureTimeOut, 20, 5);
    }

    public TriggeredScraperImpl(ResultHandler resultHandler, PlcDriverManager plcDriverManager, List<ScrapeJob> jobs, TriggerCollector triggerCollector, long futureTimeOut, int poolSizeScheduler, int poolSizeExecutor) {
        this.resultHandler = resultHandler;
        Validate.notEmpty(jobs);
        if (!(plcDriverManager instanceof PooledPlcDriverManager)) {
            LOGGER.warn("The Triggered Scraper is intended to be used with a Pooled Connection. In other situations leaks could occur!");
        }
        this.driverManager = plcDriverManager;
        this.jobs = jobs;
        this.triggerCollector = triggerCollector;
        this.futureTimeOut = futureTimeOut;
        this.scheduler = Executors.newScheduledThreadPool(poolSizeScheduler, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("triggeredscraper-scheduling-thread-%d").daemon(false).build());
        this.executorService = Executors.newFixedThreadPool(poolSizeExecutor, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("triggeredscraper-executor-thread-%d").daemon(true).build());
    }

    private static PooledPlcDriverManager createPooledDriverManager() {
        return new PooledPlcDriverManager(pooledPlcConnectionFactory -> {
            GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
            poolConfig.setMinIdlePerKey(1);
            poolConfig.setTestOnBorrow(true);
            poolConfig.setTestOnReturn(true);
            return new GenericKeyedObjectPool((KeyedPooledObjectFactory)pooledPlcConnectionFactory, poolConfig);
        });
    }

    @Override
    public void start() {
        LOGGER.info("Starting jobs...");
        for (ScrapeJob job : this.jobs) {
            for (Map.Entry<String, String> sourceEntry : job.getSourceConnections().entrySet()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Register task for job {} for conn {} ({}) at rate {} ms", new Object[]{job.getJobName(), sourceEntry.getKey(), sourceEntry.getValue(), job.getScrapeRate()});
                }
                try {
                    TriggeredScraperTask triggeredScraperTask = new TriggeredScraperTask(this.driverManager, job.getJobName(), sourceEntry.getKey(), sourceEntry.getValue(), job.getFields(), this.futureTimeOut, this.executorService, this.resultHandler, (TriggeredScrapeJobImpl)job, this.triggerCollector);
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Task {} added to scheduling", (Object)triggeredScraperTask);
                    }
                    this.registerTaskMBean(triggeredScraperTask);
                    this.tasks.put((Object)job, (Object)triggeredScraperTask);
                    ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(triggeredScraperTask, 0L, job.getScrapeRate(), TimeUnit.MILLISECONDS);
                    this.scraperTaskMap.put((Object)triggeredScraperTask, future);
                }
                catch (ScraperException e) {
                    LOGGER.warn("Error executing the job {} for conn {} ({}) at rate {} ms", new Object[]{job.getJobName(), sourceEntry.getKey(), sourceEntry.getValue(), job.getScrapeRate(), e});
                }
            }
        }
        this.statisticsLogger = this.scheduler.scheduleAtFixedRate(() -> {
            for (Map.Entry entry : this.tasks.entries()) {
                DescriptiveStatistics statistics = ((ScraperTask)entry.getValue()).getLatencyStatistics();
                String msg = String.format(Locale.ENGLISH, "Job statistics (%s, %s) number of requests: %d (%d success, %.1f %% failed, %.1f %% too slow), min latency: %.2f ms, mean latency: %.2f ms, median: %.2f ms", ((ScraperTask)entry.getValue()).getJobName(), ((ScraperTask)entry.getValue()).getConnectionAlias(), ((ScraperTask)entry.getValue()).getRequestCounter(), ((ScraperTask)entry.getValue()).getSuccessfullRequestCounter(), ((ScraperTask)entry.getValue()).getPercentageFailed(), statistics.apply((UnivariateStatistic)new PercentageAboveThreshold((double)((ScrapeJob)entry.getKey()).getScrapeRate() * 1000000.0)), statistics.getMin() * 1.0E-6, statistics.getMean() * 1.0E-6, statistics.getPercentile(50.0) * 1.0E-6);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug(msg);
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    private void registerTaskMBean(ScraperTask task) {
    }

    @Override
    public void stop() {
        LOGGER.info("Stopping scraper...");
        for (Map.Entry entry : this.scraperTaskMap.entries()) {
            LOGGER.debug("Stopping task {}...", entry.getKey());
            ((ScheduledFuture)entry.getValue()).cancel(true);
        }
        this.scraperTaskMap.clear();
        if (this.statisticsLogger != null && !this.statisticsLogger.isCancelled()) {
            this.statisticsLogger.cancel(false);
        }
    }

    public static PlcConnection getPlcConnection(PlcDriverManager plcDriverManager, String connectionString, ExecutorService executorService, long requestTimeoutMs, String info) throws InterruptedException, ExecutionException, TimeoutException {
        if (!info.isEmpty() && LOGGER.isTraceEnabled()) {
            LOGGER.trace("Additional Info from caller {}", (Object)info);
        }
        CompletableFuture<PlcConnection> future = CompletableFuture.supplyAsync(() -> {
            try {
                return plcDriverManager.getConnection(connectionString);
            }
            catch (PlcConnectionException e) {
                LOGGER.warn("Unable to instantiate connection to " + connectionString, (Throwable)e);
                throw new PlcRuntimeException((Throwable)e);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to instantiate connection to " + connectionString, (Throwable)e);
                throw new PlcRuntimeException((Throwable)e);
            }
        }, executorService);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("try to get a connection to {}", (Object)connectionString);
        }
        PlcConnection plcConnection = null;
        try {
            plcConnection = future.get(requestTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.trace("Additional Info from caller {}", (Object)info, (Object)e);
            throw e;
        }
        return plcConnection;
    }

    public static PlcConnection getPlcConnection(PlcDriverManager plcDriverManager, String connectionString, ExecutorService executorService, long requestTimeoutMs) throws InterruptedException, ExecutionException, TimeoutException {
        return TriggeredScraperImpl.getPlcConnection(plcDriverManager, connectionString, executorService, requestTimeoutMs, "");
    }

    public static Map<String, Object> convertPlcResponseToMap(PlcReadResponse plcReadResponse) {
        return plcReadResponse.getFieldNames().stream().collect(Collectors.toMap(name -> name, arg_0 -> ((PlcReadResponse)plcReadResponse).getObject(arg_0)));
    }

    @Override
    public boolean isRunning() {
        return !this.scraperTaskMap.isEmpty();
    }

    @Override
    public int getNumberOfActiveTasks() {
        return (int)this.scraperTaskMap.entries().stream().filter(entry -> !((ScheduledFuture)entry.getValue()).isDone()).count();
    }
}

