/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.scraper;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.plc4x.java.PlcDriverManager;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.scraper.ResultHandler;
import org.apache.plc4x.java.scraper.ScraperTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ScraperTaskImpl
implements ScraperTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScraperTaskImpl.class);
    private final PlcDriverManager driverManager;
    private final String jobName;
    private final String connectionAlias;
    private final String connectionString;
    private final Map<String, String> fields;
    private final long requestTimeoutMs;
    private final ExecutorService handlerService;
    private final ResultHandler resultHandler;
    private final AtomicLong requestCounter = new AtomicLong(0L);
    private final AtomicLong successCounter = new AtomicLong(0L);
    private final DescriptiveStatistics latencyStatistics = new DescriptiveStatistics(1000);
    private final DescriptiveStatistics failedStatistics = new DescriptiveStatistics(1000);

    public ScraperTaskImpl(PlcDriverManager driverManager, String jobName, String connectionAlias, String connectionString, Map<String, String> fields, long requestTimeoutMs, ExecutorService handlerService, ResultHandler resultHandler) {
        Validate.notNull((Object)driverManager);
        Validate.notBlank((CharSequence)jobName);
        Validate.notBlank((CharSequence)connectionAlias);
        Validate.notBlank((CharSequence)connectionString);
        Validate.notEmpty(fields);
        Validate.isTrue((requestTimeoutMs > 0L ? 1 : 0) != 0);
        Validate.notNull((Object)resultHandler);
        this.driverManager = driverManager;
        this.jobName = jobName;
        this.connectionAlias = connectionAlias;
        this.connectionString = connectionString;
        this.fields = fields;
        this.requestTimeoutMs = requestTimeoutMs;
        this.handlerService = handlerService;
        this.resultHandler = resultHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start new scrape of task of job {} for connection {}", (Object)this.jobName, (Object)this.connectionAlias);
        }
        this.requestCounter.incrementAndGet();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        PlcConnection connection = null;
        try {
            PlcReadResponse plcReadResponse;
            CompletableFuture<PlcConnection> future = CompletableFuture.supplyAsync(() -> {
                try {
                    return this.driverManager.getConnection(this.connectionString);
                }
                catch (PlcConnectionException e) {
                    LOGGER.warn("Unable to instantiate connection to " + this.connectionString, (Throwable)e);
                    throw new PlcRuntimeException((Throwable)e);
                }
            }, this.handlerService);
            connection = future.get(10L * this.requestTimeoutMs, TimeUnit.MILLISECONDS);
            LOGGER.debug("Connection to {} established: {}", (Object)this.connectionString, (Object)connection);
            try {
                PlcReadRequest.Builder readRequestBuilder = connection.readRequestBuilder();
                this.fields.forEach((alias, qry) -> {
                    LOGGER.trace("Requesting: {} -> {}", alias, qry);
                    readRequestBuilder.addItem(alias, qry);
                });
                plcReadResponse = (PlcReadResponse)readRequestBuilder.build().execute().get(this.requestTimeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                this.handleException(e);
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception e2) {
                        LOGGER.warn("Error on closing connection", (Throwable)e2);
                    }
                }
                return;
            }
            LOGGER.debug("Performing statistics");
            stopWatch.stop();
            this.latencyStatistics.addValue((double)stopWatch.getNanoTime());
            this.failedStatistics.addValue(0.0);
            this.successCounter.incrementAndGet();
            this.validateResponse(plcReadResponse);
            CompletableFuture.runAsync(() -> this.resultHandler.handle(this.jobName, this.connectionAlias, this.transformResponseToMap(plcReadResponse)), this.handlerService);
        }
        catch (Exception e) {
            LOGGER.warn("Exception during scraping of Job {}, Connection-Alias {}: Error-message: {} - for stack-trace change logging to DEBUG", new Object[]{this.jobName, this.connectionAlias, e.getMessage()});
            this.handleException(e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    LOGGER.warn("Error on closing connection", (Throwable)e);
                }
            }
        }
    }

    private void validateResponse(PlcReadResponse response) {
        Map<String, PlcResponseCode> failedFields = response.getFieldNames().stream().filter(name -> !PlcResponseCode.OK.equals((Object)response.getResponseCode(name))).collect(Collectors.toMap(Function.identity(), arg_0 -> ((PlcReadResponse)response).getResponseCode(arg_0)));
        if (failedFields.size() > 0) {
            this.handleErrorResponse(failedFields);
        }
    }

    private Map<String, Object> transformResponseToMap(PlcReadResponse response) {
        return response.getFieldNames().stream().collect(Collectors.toMap(name -> name, arg_0 -> ((PlcReadResponse)response).getObject(arg_0)));
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    @Override
    public String getConnectionAlias() {
        return this.connectionAlias;
    }

    @Override
    public long getRequestCounter() {
        return this.requestCounter.get();
    }

    @Override
    public long getSuccessfullRequestCounter() {
        return this.successCounter.get();
    }

    @Override
    public DescriptiveStatistics getLatencyStatistics() {
        return this.latencyStatistics;
    }

    @Override
    public double getPercentageFailed() {
        return 100.0 * this.failedStatistics.getMean();
    }

    @Override
    public void handleException(Exception e) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Detailed exception occurred at scraping", (Throwable)e);
        }
        this.failedStatistics.addValue(1.0);
    }

    @Override
    public void handleErrorResponse(Map<String, PlcResponseCode> failed) {
        LOGGER.warn("Handling error responses: {}", failed);
    }
}

