/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opm;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.plc4x.java.opm.AliasRegistry;

public class SimpleAliasRegistry
implements AliasRegistry {
    private final Map<String, String> aliasMap;

    public SimpleAliasRegistry() {
        this(new ConcurrentHashMap<String, String>());
    }

    public SimpleAliasRegistry(Map<String, String> aliasMap) {
        this.aliasMap = aliasMap;
    }

    public void register(String alias, String address) {
        this.aliasMap.put(alias, address);
    }

    @Override
    public boolean canResolve(String connection, String alias) {
        return this.canResolve(alias);
    }

    @Override
    public String resolve(String connection, String alias) {
        return this.resolve(alias);
    }

    @Override
    public boolean canResolve(String alias) {
        return this.aliasMap.containsKey(alias);
    }

    @Override
    public String resolve(String alias) {
        if (!this.canResolve(alias)) {
            throw new NoSuchElementException("Unable to resolve '" + alias + "'");
        }
        return this.aliasMap.get(alias);
    }
}

