/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opm;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.plc4x.java.PlcDriverManager;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.opm.AliasRegistry;
import org.apache.plc4x.java.opm.OPMException;
import org.apache.plc4x.java.opm.OpmUtils;
import org.apache.plc4x.java.opm.PlcEntity;
import org.apache.plc4x.java.opm.PlcEntityInterceptor;
import org.apache.plc4x.java.opm.SimpleAliasRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlcEntityManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlcEntityManager.class);
    public static final String PLC_ADDRESS_FIELD_NAME = "_plcAddress";
    static final String DRIVER_MANAGER_FIELD_NAME = "_driverManager";
    static final String ALIAS_REGISTRY = "_aliasRegistry";
    public static final String LAST_FETCHED = "_lastFetched";
    public static final String LAST_WRITTEN = "_lastWritten";
    private final PlcDriverManager driverManager;
    private final SimpleAliasRegistry registry;

    public PlcEntityManager() {
        this(new PlcDriverManager());
    }

    public PlcEntityManager(PlcDriverManager driverManager) {
        this(driverManager, new SimpleAliasRegistry());
    }

    public PlcEntityManager(PlcDriverManager driverManager, SimpleAliasRegistry registry) {
        this.driverManager = driverManager;
        this.registry = registry;
    }

    public <T> T read(Class<T> clazz, String address) throws OPMException {
        T connect = this.connect(clazz, address);
        this.disconnect(connect);
        return connect;
    }

    public <T> T write(Class<T> clazz, String address, T object) throws OPMException {
        T merge = this.merge(clazz, address, object);
        this.disconnect(merge);
        return merge;
    }

    public <T> T connect(Class<T> clazz, String address) throws OPMException {
        return this.connect(clazz, address, null);
    }

    public <T> T merge(Class<T> clazz, String address, T instance) throws OPMException {
        return this.connect(clazz, address, instance);
    }

    private <T> T connect(Class<T> clazz, String address, T existingInstance) throws OPMException {
        OpmUtils.getPlcEntityAndCheckPreconditions(clazz);
        try {
            Object instance = new ByteBuddy().subclass(clazz).defineField(PLC_ADDRESS_FIELD_NAME, String.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).defineField(DRIVER_MANAGER_FIELD_NAME, PlcDriverManager.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).defineField(ALIAS_REGISTRY, AliasRegistry.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).defineField(LAST_FETCHED, Map.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).defineField(LAST_WRITTEN, Map.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).method((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(Object.class))).intercept((Implementation)MethodDelegation.to(PlcEntityInterceptor.class)).make().load(Thread.currentThread().getContextClassLoader()).getLoaded().getConstructor(new Class[0]).newInstance(new Object[0]);
            FieldUtils.writeDeclaredField(instance, (String)PLC_ADDRESS_FIELD_NAME, (Object)address, (boolean)true);
            FieldUtils.writeDeclaredField(instance, (String)DRIVER_MANAGER_FIELD_NAME, (Object)this.driverManager, (boolean)true);
            FieldUtils.writeDeclaredField(instance, (String)ALIAS_REGISTRY, (Object)this.registry, (boolean)true);
            HashMap<String, Instant> lastFetched = new HashMap<String, Instant>();
            FieldUtils.writeDeclaredField(instance, (String)LAST_FETCHED, lastFetched, (boolean)true);
            HashMap<String, Instant> lastWritten = new HashMap<String, Instant>();
            FieldUtils.writeDeclaredField(instance, (String)LAST_WRITTEN, lastWritten, (boolean)true);
            if (existingInstance == null) {
                PlcEntityInterceptor.refetchAllFields(instance, this.driverManager, address, this.registry, lastFetched);
            } else {
                FieldUtils.getAllFieldsList(clazz).stream().peek(field -> field.setAccessible(true)).forEach(field -> this.setValueToField((Field)field, instance, this.getValueFromField((Field)field, existingInstance)));
                PlcEntityInterceptor.writeAllFields(instance, this.driverManager, address, this.registry, lastWritten);
            }
            return instance;
        }
        catch (IllegalAccessError | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new OPMException("Unable to instantiate Proxy", e);
        }
    }

    private Object getValueFromField(Field field, Object object) {
        try {
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
    }

    private void setValueToField(Field field, Object object, Object value) {
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
    }

    public void disconnect(Object entity) throws OPMException {
        PlcEntity annotation = entity.getClass().getSuperclass().getAnnotation(PlcEntity.class);
        if (annotation == null) {
            throw new OPMException("Unable to disconnect Object, is no entity!");
        }
        try {
            Object manager = FieldUtils.readDeclaredField((Object)entity, (String)DRIVER_MANAGER_FIELD_NAME, (boolean)true);
            if (manager == null) {
                throw new OPMException("Instance is already disconnected!");
            }
            FieldUtils.writeDeclaredField((Object)entity, (String)DRIVER_MANAGER_FIELD_NAME, null, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new OPMException("Unable to fetch driverManager instance on entity instance", e);
        }
    }
}

