/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opm;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.FieldValue;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.SystemConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.plc4x.java.PlcDriverManager;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcRequest;
import org.apache.plc4x.java.api.messages.PlcResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.opm.AliasRegistry;
import org.apache.plc4x.java.opm.OPMException;
import org.apache.plc4x.java.opm.OpmUtils;
import org.apache.plc4x.java.opm.PlcEntity;
import org.apache.plc4x.java.opm.PlcField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlcEntityInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlcEntityInterceptor.class);
    private static final Configuration CONF = new SystemConfiguration();
    private static final long READ_TIMEOUT = CONF.getLong("org.apache.plc4x.java.opm.entity_manager.read_timeout", 1000L);

    private PlcEntityInterceptor() {
        throw new UnsupportedOperationException("This class is not to be instantiated");
    }

    @RuntimeType
    public static Object interceptGetter(@This Object proxy, @Origin Method method, @SuperCall Callable<?> callable, @FieldValue(value="_plcAddress") String address, @FieldValue(value="_driverManager") PlcDriverManager driverManager, @FieldValue(value="_aliasRegistry") AliasRegistry registry, @FieldValue(value="_lastFetched") Map<String, Instant> lastFetched, @FieldValue(value="_lastWritten") Map<String, Instant> lastWritten) throws OPMException {
        LOGGER.trace("Invoked method {} on connected PlcEntity {}", (Object)method.getName(), (Object)method.getDeclaringClass().getName());
        if (driverManager == null) {
            LOGGER.trace("Entity not connected, simply fowarding call");
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new OPMException("Exception during forwarding call", e);
            }
        }
        if (method.getName().startsWith("get")) {
            if (method.getParameterCount() > 0) {
                throw new OPMException("Only getter with no arguments are supported");
            }
            LOGGER.trace("Invoked method {} is getter, trying to find annotated field and return requested value", (Object)method.getName());
            PlcEntityInterceptor.fetchAndSetValueForGetter(proxy, method, driverManager, address, registry, lastFetched);
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new OPMException("Unable to forward invocation " + method.getName() + " on connected PlcEntity", e);
            }
        }
        if (method.getName().startsWith("is") && (method.getReturnType() == Boolean.TYPE || method.getReturnType() == Boolean.class)) {
            if (method.getParameterCount() > 0) {
                throw new OPMException("Only getter with no arguments are supported");
            }
            LOGGER.trace("Invoked method {} is boolean flag method, trying to find annotated field and return requested value", (Object)method.getName());
            PlcEntityInterceptor.fetchAndSetValueForIsGetter(proxy, method, driverManager, address, registry, lastFetched);
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new OPMException("Unable to forward invocation " + method.getName() + " on connected PlcEntity", e);
            }
        }
        try {
            LOGGER.trace("Invoked method is no getter, refetch all fields and invoke method {} then", (Object)method.getName());
            PlcEntityInterceptor.refetchAllFields(proxy, driverManager, address, registry, lastFetched);
            Object call = callable.call();
            PlcEntityInterceptor.writeAllFields(proxy, driverManager, address, registry, lastWritten);
            return call;
        }
        catch (Exception e) {
            throw new OPMException("Unable to forward invocation " + method.getName() + " on connected PlcEntity", e);
        }
    }

    @RuntimeType
    public static Object interceptSetter(@This Object proxy, @Origin Method method, @SuperCall Callable<?> callable, @FieldValue(value="_plcAddress") String address, @FieldValue(value="_driverManager") PlcDriverManager driverManager, @FieldValue(value="_aliasRegistry") AliasRegistry registry, @FieldValue(value="_lastFetched") Map<String, Instant> lastFetched, @Argument(value=0) Object argument) throws OPMException {
        LOGGER.trace("Invoked method {} on connected PlcEntity {}", (Object)method.getName(), (Object)method.getDeclaringClass().getName());
        if (driverManager == null) {
            LOGGER.trace("Entity not connected, simply fowarding call");
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new OPMException("Exception during forwarding call", e);
            }
        }
        if (method.getName().startsWith("set")) {
            if (method.getParameterCount() != 1) {
                throw new OPMException("Only setter with one arguments are supported");
            }
            LOGGER.trace("Invoked method {} is setter, trying to find annotated field and return requested value", (Object)method.getName());
            return PlcEntityInterceptor.setValueForSetter(proxy, method, callable, driverManager, address, registry, lastFetched, argument);
        }
        try {
            LOGGER.trace("Invoked method is no getter, refetch all fields and invoke method {} then", (Object)method.getName());
            PlcEntityInterceptor.refetchAllFields(proxy, driverManager, address, registry, lastFetched);
            return callable.call();
        }
        catch (Exception e) {
            throw new OPMException("Unable to forward invocation " + method.getName() + " on connected PlcEntity", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void refetchAllFields(Object proxy, PlcDriverManager driverManager, String address, AliasRegistry registry, Map<String, Instant> lastFetched) throws OPMException {
        Class<?> entityClass = proxy.getClass().getSuperclass();
        LOGGER.trace("Refetching all fields on proxy object of class {}", entityClass);
        PlcEntity plcEntity = entityClass.getAnnotation(PlcEntity.class);
        if (plcEntity == null) {
            throw new OPMException("Non PlcEntity supplied");
        }
        for (Field field2 : entityClass.getDeclaredFields()) {
            if (!field2.isAnnotationPresent(PlcField.class)) continue;
            OpmUtils.getOrResolveAddress(registry, field2.getAnnotation(PlcField.class).value());
        }
        try (PlcConnection connection = driverManager.getConnection(address);){
            PlcReadRequest.Builder requestBuilder = connection.readRequestBuilder();
            Arrays.stream(entityClass.getDeclaredFields()).filter(field -> field.isAnnotationPresent(PlcField.class)).filter(field -> PlcEntityInterceptor.needsToBeSynced(lastFetched, field)).forEach(field -> requestBuilder.addItem(PlcEntityInterceptor.getFqn(field), OpmUtils.getOrResolveAddress(registry, field.getAnnotation(PlcField.class).value())));
            PlcReadRequest request = requestBuilder.build();
            LOGGER.trace("Request for refetch of {} was build and is {}", entityClass, (Object)request);
            PlcReadResponse response = PlcEntityInterceptor.getPlcReadResponse(request);
            for (String fieldName : response.getFieldNames()) {
                lastFetched.put(fieldName, Instant.now());
                LOGGER.trace("Value for field {}  is {}", (Object)fieldName, response.getObject(fieldName));
                String clazzFieldName = StringUtils.substringAfterLast((String)fieldName, (String)".");
                try {
                    PlcEntityInterceptor.setField(entityClass, proxy, response, clazzFieldName, fieldName);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new PlcRuntimeException((Throwable)e);
                    return;
                }
            }
        }
        catch (PlcConnectionException e) {
            throw new OPMException("Problem during processing", e);
        }
        catch (Exception e) {
            throw new OPMException("Unexpected error during processing", e);
        }
    }

    static void writeAllFields(Object proxy, PlcDriverManager driverManager, String address, AliasRegistry registry, Map<String, Instant> lastWritten) throws OPMException {
        Class<?> entityClass = proxy.getClass().getSuperclass();
        LOGGER.trace("Writing all fields on proxy object of class {}", entityClass);
        PlcEntity plcEntity = entityClass.getAnnotation(PlcEntity.class);
        if (plcEntity == null) {
            throw new OPMException("Non PlcEntity supplied");
        }
        for (Field field2 : entityClass.getDeclaredFields()) {
            if (!field2.isAnnotationPresent(PlcField.class)) continue;
            OpmUtils.getOrResolveAddress(registry, field2.getAnnotation(PlcField.class).value());
        }
        try (PlcConnection connection = driverManager.getConnection(address);){
            PlcWriteRequest.Builder requestBuilder = connection.writeRequestBuilder();
            Arrays.stream(entityClass.getDeclaredFields()).filter(field -> field.isAnnotationPresent(PlcField.class)).filter(field -> PlcEntityInterceptor.needsToBeSynced(lastWritten, field)).forEach(field -> requestBuilder.addItem(PlcEntityInterceptor.getFqn(field), OpmUtils.getOrResolveAddress(registry, field.getAnnotation(PlcField.class).value()), new Object[]{PlcEntityInterceptor.getFromField(field, proxy)}));
            PlcWriteRequest request = requestBuilder.build();
            LOGGER.trace("Request for write of {} was build and is {}", entityClass, (Object)request);
            PlcWriteResponse response = PlcEntityInterceptor.getPlcWriteResponse(request);
            for (String fieldName : response.getFieldNames()) {
                lastWritten.put(fieldName, Instant.now());
            }
        }
        catch (PlcConnectionException e) {
            throw new OPMException("Problem during processing", e);
        }
        catch (Exception e) {
            throw new OPMException("Unexpected error during processing", e);
        }
    }

    private static Object getFromField(Field field, Object object) {
        try {
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
    }

    private static String getFqn(Field field) {
        return field.getDeclaringClass().getName() + "." + field.getName();
    }

    private static boolean needsToBeSynced(Map<String, Instant> lastSynced, Field field) {
        Validate.notNull((Object)field);
        long cacheDurationMillis = field.getAnnotation(PlcField.class).cacheDurationMillis();
        if (cacheDurationMillis < 0L) {
            return true;
        }
        String fqn = PlcEntityInterceptor.getFqn(field);
        if (lastSynced.containsKey(fqn)) {
            Instant last = lastSynced.get(fqn);
            return Instant.now().minus(cacheDurationMillis, ChronoUnit.MILLIS).isAfter(last);
        }
        return true;
    }

    private static void fetchAndSetValueForIsGetter(Object proxy, Method m, PlcDriverManager driverManager, String address, AliasRegistry registry, Map<String, Instant> lastFetched) throws OPMException {
        PlcEntityInterceptor.fetchAndSetValueForGetter(proxy, m, 2, driverManager, address, registry, lastFetched);
    }

    private static void fetchAndSetValueForGetter(Object proxy, Method m, PlcDriverManager driverManager, String address, AliasRegistry registry, Map<String, Instant> lastFetched) throws OPMException {
        PlcEntityInterceptor.fetchAndSetValueForGetter(proxy, m, 3, driverManager, address, registry, lastFetched);
    }

    private static void fetchAndSetValueForGetter(Object proxy, Method m, int prefixLength, PlcDriverManager driverManager, String address, AliasRegistry registry, Map<String, Instant> lastFetched) throws OPMException {
        PlcField annotation;
        Field field;
        String s = m.getName().substring(prefixLength);
        String variable = s.substring(0, 1).toLowerCase().concat(s.substring(1));
        LOGGER.trace("Looking for field with name {} after invokation of getter {}", (Object)variable, (Object)m.getName());
        try {
            field = m.getDeclaringClass().getDeclaredField(variable);
            annotation = field.getDeclaredAnnotation(PlcField.class);
        }
        catch (NoSuchFieldException e) {
            throw new OPMException("Unable to identify field with name '" + variable + "' for call to '" + m.getName() + "'", e);
        }
        String fqn = PlcEntityInterceptor.getFqn(field);
        if (!PlcEntityInterceptor.needsToBeSynced(lastFetched, field)) {
            return;
        }
        try (PlcConnection connection = driverManager.getConnection(address);){
            PlcReadRequest request = connection.readRequestBuilder().addItem(fqn, OpmUtils.getOrResolveAddress(registry, annotation.value())).build();
            PlcReadResponse response = PlcEntityInterceptor.getPlcReadResponse(request);
            lastFetched.put(field.getName(), Instant.now());
            Object value = PlcEntityInterceptor.getTyped(m.getReturnType(), response, fqn);
            PlcEntityInterceptor.setForField(field, proxy, value);
        }
        catch (ClassCastException e) {
            throw new OPMException("Unable to return response as suitable type", e);
        }
        catch (Exception e) {
            throw new OPMException("Problem during processing", e);
        }
    }

    private static void setForField(Field field, Object proxy, Object value) {
        try {
            field.setAccessible(true);
            field.set(proxy, value);
        }
        catch (IllegalAccessException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
    }

    private static Object setValueForSetter(Object proxy, Method m, Callable<?> callable, PlcDriverManager driverManager, String address, AliasRegistry registry, Map<String, Instant> lastFetched, Object object) throws OPMException {
        Object var16_21;
        block12: {
            PlcField annotation;
            Field field;
            String s = m.getName().substring(3);
            String variable = s.substring(0, 1).toLowerCase().concat(s.substring(1));
            LOGGER.trace("Looking for field with name {} after invokation of getter {}", (Object)variable, (Object)m.getName());
            try {
                field = m.getDeclaringClass().getDeclaredField(variable);
                annotation = field.getDeclaredAnnotation(PlcField.class);
            }
            catch (NoSuchFieldException e) {
                throw new OPMException("Unable to identify field with name '" + variable + "' for call to '" + m.getName() + "'", e);
            }
            String fqn = PlcEntityInterceptor.getFqn(field);
            PlcConnection connection = driverManager.getConnection(address);
            try {
                PlcWriteRequest request = connection.writeRequestBuilder().addItem(fqn, OpmUtils.getOrResolveAddress(registry, annotation.value()), new Object[]{object}).build();
                PlcWriteResponse response = PlcEntityInterceptor.getPlcWriteResponse(request);
                lastFetched.put(field.getName(), Instant.now());
                LOGGER.debug("getTyped clazz: {}, response: {}, fieldName: {}", new Object[]{m.getParameters()[0].getType(), response, fqn});
                if (response.getResponseCode(fqn) != PlcResponseCode.OK) {
                    throw new PlcRuntimeException(String.format("Unable to read specified field '%s', response code was '%s'", fqn, response.getResponseCode(fqn)));
                }
                callable.call();
                var16_21 = null;
                if (connection == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ClassCastException e) {
                    throw new OPMException("Unable to return response as suitable type", e);
                }
                catch (Exception e) {
                    throw new OPMException("Problem during processing", e);
                }
            }
            connection.close();
        }
        return var16_21;
    }

    static void setField(Class<?> clazz, Object o, PlcReadResponse response, String targetFieldName, String sourceFieldName) throws NoSuchFieldException, IllegalAccessException {
        LOGGER.debug("setField on clazz: {}, Object: {}, response: {}, targetFieldName: {}, sourceFieldName:{} ", new Object[]{clazz, o, response, targetFieldName, sourceFieldName});
        Field field = clazz.getDeclaredField(targetFieldName);
        field.setAccessible(true);
        try {
            field.set(o, PlcEntityInterceptor.getTyped(field.getType(), response, sourceFieldName));
        }
        catch (ClassCastException e) {
            throw new PlcRuntimeException(String.format("Unable to assign return value %s to field %s with type %s", response.getObject(sourceFieldName), targetFieldName, field.getType()), (Throwable)e);
        }
    }

    static Object getTyped(Class<?> clazz, PlcReadResponse response, String sourceFieldName) {
        LOGGER.debug("getTyped clazz: {}, response: {}, fieldName: {}", new Object[]{clazz, response, sourceFieldName});
        if (response.getResponseCode(sourceFieldName) != PlcResponseCode.OK) {
            throw new PlcRuntimeException(String.format("Unable to read specified field '%s', response code was '%s'", sourceFieldName, response.getResponseCode(sourceFieldName)));
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return response.getBoolean(sourceFieldName);
            }
            if (clazz == Byte.TYPE) {
                return response.getByte(sourceFieldName);
            }
            if (clazz == Short.TYPE) {
                return response.getShort(sourceFieldName);
            }
            if (clazz == Integer.TYPE) {
                return response.getInteger(sourceFieldName);
            }
            if (clazz == Long.TYPE) {
                return response.getLong(sourceFieldName);
            }
        }
        if (clazz == Boolean.class) {
            return response.getBoolean(sourceFieldName);
        }
        if (clazz == Byte.class) {
            return response.getByte(sourceFieldName);
        }
        if (clazz == Short.class) {
            return response.getShort(sourceFieldName);
        }
        if (clazz == Integer.class) {
            return response.getInteger(sourceFieldName);
        }
        if (clazz == Long.class) {
            return response.getLong(sourceFieldName);
        }
        if (clazz == BigInteger.class) {
            return response.getBigInteger(sourceFieldName);
        }
        if (clazz == Float.class) {
            return response.getFloat(sourceFieldName);
        }
        if (clazz == Double.class) {
            return response.getDouble(sourceFieldName);
        }
        if (clazz == BigDecimal.class) {
            return response.getBigDecimal(sourceFieldName);
        }
        if (clazz == String.class) {
            return response.getString(sourceFieldName);
        }
        if (clazz == LocalTime.class) {
            return response.getTime(sourceFieldName);
        }
        if (clazz == LocalDate.class) {
            return response.getDate(sourceFieldName);
        }
        if (clazz == LocalDateTime.class) {
            return response.getDateTime(sourceFieldName);
        }
        Object responseObject = response.getObject(sourceFieldName);
        if (clazz.isAssignableFrom(responseObject.getClass())) {
            return responseObject;
        }
        throw new ClassCastException("Unable to return response item " + responseObject + "(" + responseObject.getClass() + ") as instance of " + clazz);
    }

    static PlcReadResponse getPlcReadResponse(PlcReadRequest request) throws OPMException {
        return (PlcReadResponse)PlcEntityInterceptor.getFromFuture(request);
    }

    public static PlcWriteResponse getPlcWriteResponse(PlcWriteRequest request) throws OPMException {
        return (PlcWriteResponse)PlcEntityInterceptor.getFromFuture(request);
    }

    private static <REQ extends PlcRequest, RES extends PlcResponse> RES getFromFuture(REQ request) throws OPMException {
        try {
            return (RES)((PlcResponse)request.execute().get(READ_TIMEOUT, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OPMException("Exception during execution", e);
        }
        catch (ExecutionException e) {
            throw new OPMException("Exception during execution", e);
        }
        catch (TimeoutException e) {
            throw new OPMException("Timeout during fetching values", e);
        }
    }
}

