/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opm;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.apache.plc4x.java.opm.AliasRegistry;
import org.apache.plc4x.java.opm.PlcEntity;

final class OpmUtils {
    private static final String ADDRESS = "address";
    static final Pattern pattern = Pattern.compile("^\\$\\{(?<address>.*)}$");

    private OpmUtils() {
    }

    static <T> PlcEntity getPlcEntityAndCheckPreconditions(Class<T> clazz) {
        PlcEntity annotation = clazz.getAnnotation(PlcEntity.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Given Class is no Plc Entity, i.e., not annotated with @PlcEntity");
        }
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Cannot use PlcEntity without default constructor", e);
        }
        return annotation;
    }

    static String getOrResolveAddress(AliasRegistry registry, String addressString) {
        if (!OpmUtils.isValidExpression(addressString)) {
            throw new IllegalArgumentException("Invalid Syntax, either use field address (no starting $) or an alias with Syntax ${xxx}. But given was '" + addressString + "'");
        }
        if (!OpmUtils.isAlias(addressString)) {
            return addressString;
        }
        String alias = OpmUtils.getAlias(addressString);
        if (registry.canResolve(alias)) {
            return registry.resolve(alias);
        }
        throw new IllegalArgumentException("Unable to resolve Alias '" + alias + "' in Schema Registry");
    }

    static boolean isValidExpression(String s) {
        Validate.notNull((Object)s);
        return !s.startsWith("$") || pattern.matcher(s).matches();
    }

    static boolean isAlias(String s) {
        Validate.notNull((Object)s);
        return s.startsWith("$") && pattern.matcher(s).matches();
    }

    static String getAlias(String s) {
        Matcher matcher = pattern.matcher(s);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid Syntax, no Alias found in String '" + s + "'. Syntax is ${xxx}");
        }
        return matcher.group(ADDRESS);
    }
}

