/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.simulated.field;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.value.PlcBigDecimal;
import org.apache.plc4x.java.api.value.PlcBigInteger;
import org.apache.plc4x.java.api.value.PlcBoolean;
import org.apache.plc4x.java.api.value.PlcDate;
import org.apache.plc4x.java.api.value.PlcDateTime;
import org.apache.plc4x.java.api.value.PlcDouble;
import org.apache.plc4x.java.api.value.PlcFloat;
import org.apache.plc4x.java.api.value.PlcInteger;
import org.apache.plc4x.java.api.value.PlcList;
import org.apache.plc4x.java.api.value.PlcLong;
import org.apache.plc4x.java.api.value.PlcString;
import org.apache.plc4x.java.api.value.PlcTime;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.simulated.field.SimulatedField;
import org.apache.plc4x.java.spi.connection.PlcFieldHandler;

public class SimulatedFieldHandler
implements PlcFieldHandler {
    public PlcField createField(String fieldQuery) {
        if (SimulatedField.matches(fieldQuery)) {
            return SimulatedField.of(fieldQuery);
        }
        throw new PlcInvalidFieldException(fieldQuery);
    }

    public PlcValue encodeBoolean(PlcField field, Object[] values) {
        SimulatedField testField = (SimulatedField)field;
        if (testField.getDataType() == Boolean.class) {
            if (values.length == 1) {
                return new PlcBoolean((Boolean)values[0]);
            }
            return new PlcList(Arrays.asList(values));
        }
        throw new PlcRuntimeException("Invalid encoder for type " + testField.getDataType().getName());
    }

    public PlcValue encodeByte(PlcField field, Object[] values) {
        SimulatedField testField = (SimulatedField)field;
        if (testField.getDataType() == Byte.class) {
            if (values.length == 1) {
                return new PlcInteger((int)((Byte)values[0]).byteValue());
            }
            return new PlcList(Arrays.asList(values));
        }
        throw new PlcRuntimeException("Invalid encoder for type " + testField.getDataType().getName());
    }

    public PlcValue encodeShort(PlcField field, Object[] values) {
        SimulatedField testField = (SimulatedField)field;
        if (testField.getDataType() == Short.class) {
            if (values.length == 1) {
                return new PlcInteger((int)((Short)values[0]).shortValue());
            }
            return new PlcList(Arrays.asList(values));
        }
        throw new PlcRuntimeException("Invalid encoder for type " + testField.getDataType().getName());
    }

    public PlcValue encodeInteger(PlcField field, Object[] values) {
        SimulatedField testField = (SimulatedField)field;
        if (testField.getDataType() == Integer.class) {
            if (values.length == 1) {
                return new PlcInteger((Integer)values[0]);
            }
            return new PlcList(Arrays.asList(values));
        }
        throw new PlcRuntimeException("Invalid encoder for type " + testField.getDataType().getName());
    }

    public PlcValue encodeBigInteger(PlcField field, Object[] values) {
        SimulatedField testField = (SimulatedField)field;
        if (testField.getDataType() == BigInteger.class) {
            if (values.length == 1) {
                return new PlcBigInteger((BigInteger)values[0]);
            }
            return new PlcList(Arrays.asList(values));
        }
        throw new PlcRuntimeException("Invalid encoder for type " + testField.getDataType().getName());
    }

    public PlcValue encodeLong(PlcField field, Object[] values) {
        SimulatedField testField = (SimulatedField)field;
        if (testField.getDataType() == Long.class) {
            if (values.length == 1) {
                return new PlcLong((Long)values[0]);
            }
            return new PlcList(Arrays.asList(values));
        }
        throw new PlcRuntimeException("Invalid encoder for type " + testField.getDataType().getName());
    }

    public PlcValue encodeFloat(PlcField field, Object[] values) {
        SimulatedField testField = (SimulatedField)field;
        if (testField.getDataType() == Float.class) {
            if (values.length == 1) {
                return new PlcFloat((Float)values[0]);
            }
            return new PlcList(Arrays.asList(values));
        }
        throw new PlcRuntimeException("Invalid encoder for type " + testField.getDataType().getName());
    }

    public PlcValue encodeBigDecimal(PlcField field, Object[] values) {
        SimulatedField testField = (SimulatedField)field;
        if (testField.getDataType() == BigDecimal.class) {
            if (values.length == 1) {
                return new PlcBigDecimal((BigDecimal)values[0]);
            }
            return new PlcList(Arrays.asList(values));
        }
        throw new PlcRuntimeException("Invalid encoder for type " + testField.getDataType().getName());
    }

    public PlcValue encodeDouble(PlcField field, Object[] values) {
        SimulatedField testField = (SimulatedField)field;
        if (testField.getDataType() == Double.class) {
            if (values.length == 1) {
                return new PlcDouble((Double)values[0]);
            }
            return new PlcList(Arrays.asList(values));
        }
        throw new PlcRuntimeException("Invalid encoder for type " + testField.getDataType().getName());
    }

    public PlcValue encodeString(PlcField field, Object[] values) {
        SimulatedField testField = (SimulatedField)field;
        if (testField.getDataType() == String.class) {
            if (values.length == 1) {
                return new PlcString((String)values[0]);
            }
            return new PlcList(Arrays.asList(values));
        }
        throw new PlcRuntimeException("Invalid encoder for type " + testField.getDataType().getName());
    }

    public PlcValue encodeTime(PlcField field, Object[] values) {
        SimulatedField testField = (SimulatedField)field;
        if (testField.getDataType() == LocalTime.class) {
            if (values.length == 1) {
                return new PlcTime((LocalTime)values[0]);
            }
            return new PlcList(Arrays.asList(values));
        }
        throw new PlcRuntimeException("Invalid encoder for type " + testField.getDataType().getName());
    }

    public PlcValue encodeDate(PlcField field, Object[] values) {
        SimulatedField testField = (SimulatedField)field;
        if (testField.getDataType() == LocalDate.class) {
            if (values.length == 1) {
                return new PlcDate((LocalDate)values[0]);
            }
            return new PlcList(Arrays.asList(values));
        }
        throw new PlcRuntimeException("Invalid encoder for type " + testField.getDataType().getName());
    }

    public PlcValue encodeDateTime(PlcField field, Object[] values) {
        SimulatedField testField = (SimulatedField)field;
        if (testField.getDataType() == LocalDateTime.class) {
            if (values.length == 1) {
                return new PlcDateTime((LocalDateTime)values[0]);
            }
            return new PlcList(Arrays.asList(values));
        }
        throw new PlcRuntimeException("Invalid encoder for type " + testField.getDataType().getName());
    }
}

