/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.simulated.field;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.WordUtils;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.simulated.types.SimulatedFieldType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulatedField
implements PlcField {
    private static final Logger logger = LoggerFactory.getLogger(SimulatedField.class);
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("^(?<type>\\w+)/(?<name>\\w+):(?<dataType>[a-zA-Z]++)(\\[(?<numElements>\\d+)])?$");
    private final SimulatedFieldType type;
    private final String name;
    private final Class<?> dataType;
    private final int numElements;

    private SimulatedField(SimulatedFieldType type, String name, Class<?> dataType, int numElements) {
        this.type = type;
        this.name = name;
        this.dataType = dataType;
        this.numElements = numElements;
    }

    public static SimulatedField of(String fieldString) throws PlcInvalidFieldException {
        Matcher matcher = ADDRESS_PATTERN.matcher(fieldString);
        if (matcher.matches()) {
            SimulatedFieldType type = SimulatedFieldType.valueOf(matcher.group("type"));
            String name = matcher.group("name");
            String dataTypeName = WordUtils.capitalizeFully((String)matcher.group("dataType"));
            int numElements = 1;
            if (matcher.group("numElements") != null) {
                numElements = Integer.parseInt(matcher.group("numElements"));
            }
            try {
                Class<?> dataType = Class.forName("java.lang." + dataTypeName);
                return new SimulatedField(type, name, dataType, numElements);
            }
            catch (ClassNotFoundException e) {
                logger.error("Unsupported type: " + dataTypeName, (Throwable)e);
                throw new PlcInvalidFieldException("Unsupported type: " + dataTypeName);
            }
        }
        throw new PlcInvalidFieldException("Unable to parse address: " + fieldString);
    }

    static boolean matches(String fieldString) {
        return ADDRESS_PATTERN.matcher(fieldString).matches();
    }

    public SimulatedFieldType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getDataType() {
        return this.dataType;
    }

    public int getNumElements() {
        return this.numElements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimulatedField testField = (SimulatedField)o;
        return this.numElements == testField.numElements && this.type == testField.type && Objects.equals(this.name, testField.name) && Objects.equals(this.dataType, testField.dataType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.dataType, this.numElements});
    }

    public String toString() {
        return "TestField{type=" + (Object)((Object)this.type) + ", name='" + this.name + '\'' + ", dataType=" + this.dataType + ", numElements=" + this.numElements + '}';
    }
}

