/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.simulated.connection;

import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.api.value.PlcValues;
import org.apache.plc4x.java.simulated.field.SimulatedField;
import org.apache.plc4x.java.spi.model.InternalPlcSubscriptionHandle;

public class SimulatedDevice {
    private final Random random = new Random();
    private final String name;
    private final Map<SimulatedField, PlcValue> state = new HashMap<SimulatedField, PlcValue>();
    private final Map<PlcSubscriptionHandle, ScheduledFuture<?>> cyclicSubscriptions = new HashMap();
    private final Map<PlcSubscriptionHandle, Future<?>> eventSubscriptions = new HashMap();
    private final IdentityHashMap<PlcSubscriptionHandle, Pair<SimulatedField, Consumer<PlcValue>>> changeOfStateSubscriptions = new IdentityHashMap();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final ExecutorService pool = Executors.newCachedThreadPool();

    public SimulatedDevice(String name) {
        this.name = name;
    }

    public Optional<PlcValue> get(SimulatedField field) {
        Objects.requireNonNull(field);
        switch (field.getType()) {
            case STATE: {
                return Optional.ofNullable(this.state.get(field));
            }
            case RANDOM: {
                return Optional.of(this.randomValue(field.getDataType()));
            }
            case STDOUT: {
                return Optional.empty();
            }
        }
        throw new IllegalArgumentException("Unsupported field type: " + field.getType().name());
    }

    public void set(SimulatedField field, PlcValue value) {
        Objects.requireNonNull(field);
        switch (field.getType()) {
            case STATE: {
                this.changeOfStateSubscriptions.values().stream().filter(pair -> ((SimulatedField)pair.getKey()).equals(field)).map(Pair::getValue).forEach(baseDefaultPlcValueConsumer -> baseDefaultPlcValueConsumer.accept(value));
                this.state.put(field, value);
                return;
            }
            case STDOUT: {
                System.out.printf("TEST PLC STDOUT [%s]: %s%n", field.getName(), value.getString());
                return;
            }
            case RANDOM: {
                System.out.printf("TEST PLC RANDOM [%s]: %s%n", field.getName(), value.getString());
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported field type: " + field.getType().name());
    }

    private PlcValue randomValue(Class<?> type) {
        Object result = null;
        if (type.equals(Byte.class)) {
            return PlcValues.of((byte)((byte)this.random.nextInt(256)));
        }
        if (type.equals(Short.class)) {
            return PlcValues.of((short)((short)this.random.nextInt(65536)));
        }
        if (type.equals(Integer.class)) {
            return PlcValues.of((int)this.random.nextInt());
        }
        if (type.equals(Long.class)) {
            return PlcValues.of((long)this.random.nextLong());
        }
        if (type.equals(Float.class)) {
            return PlcValues.of((float)this.random.nextFloat());
        }
        if (type.equals(Double.class)) {
            return PlcValues.of((double)this.random.nextDouble());
        }
        if (type.equals(Boolean.class)) {
            return PlcValues.of((boolean)this.random.nextBoolean());
        }
        if (type.equals(String.class)) {
            int length = this.random.nextInt(100);
            StringBuilder sb = new StringBuilder(length);
            for (int i = 0; i < length; ++i) {
                char c = (char)(97 + this.random.nextInt(26));
                sb.append(c);
            }
            return PlcValues.of((String)sb.toString());
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public void addCyclicSubscription(Consumer<PlcValue> consumer, PlcSubscriptionHandle handle, SimulatedField plcField, Duration duration) {
        ScheduledFuture<?> scheduledFuture = this.scheduler.scheduleAtFixedRate(() -> {
            PlcValue baseDefaultPlcValue = this.state.get(plcField);
            if (baseDefaultPlcValue == null) {
                return;
            }
            consumer.accept(baseDefaultPlcValue);
        }, duration.toMillis(), duration.toMillis(), TimeUnit.MILLISECONDS);
        this.cyclicSubscriptions.put(handle, scheduledFuture);
    }

    public void addChangeOfStateSubscription(Consumer<PlcValue> consumer, PlcSubscriptionHandle handle, SimulatedField plcField) {
        this.changeOfStateSubscriptions.put(handle, (Pair<SimulatedField, Consumer<PlcValue>>)Pair.of((Object)plcField, consumer));
    }

    public void addEventSubscription(Consumer<PlcValue> consumer, PlcSubscriptionHandle handle, SimulatedField plcField) {
        Future<?> submit = this.pool.submit(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                PlcValue baseDefaultPlcValue = this.state.get(plcField);
                if (baseDefaultPlcValue == null) continue;
                consumer.accept(baseDefaultPlcValue);
                try {
                    TimeUnit.SECONDS.sleep((long)(Math.random() * 10.0));
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        });
        this.eventSubscriptions.put(handle, submit);
    }

    public void removeHandles(Collection<? extends InternalPlcSubscriptionHandle> internalPlcSubscriptionHandles) {
        internalPlcSubscriptionHandles.forEach(handle -> {
            ScheduledFuture<?> remove = this.cyclicSubscriptions.remove(handle);
            if (remove == null) {
                return;
            }
            remove.cancel(true);
        });
        internalPlcSubscriptionHandles.forEach(handle -> {
            Future<?> remove = this.eventSubscriptions.remove(handle);
            if (remove == null) {
                return;
            }
            remove.cancel(true);
        });
        internalPlcSubscriptionHandles.forEach(this.changeOfStateSubscriptions::remove);
    }
}

