/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.simulated.connection;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.simulated.connection.SimulatedDevice;
import org.apache.plc4x.java.simulated.field.SimulatedField;
import org.apache.plc4x.java.simulated.field.SimulatedFieldHandler;
import org.apache.plc4x.java.spi.connection.AbstractPlcConnection;
import org.apache.plc4x.java.spi.connection.PlcFieldHandler;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionEvent;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcUnsubscriptionRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcUnsubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.InternalPlcReadRequest;
import org.apache.plc4x.java.spi.messages.InternalPlcSubscriptionRequest;
import org.apache.plc4x.java.spi.messages.InternalPlcUnsubscriptionRequest;
import org.apache.plc4x.java.spi.messages.InternalPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.PlcReader;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.PlcWriter;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.model.DefaultPlcConsumerRegistration;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionHandle;
import org.apache.plc4x.java.spi.model.InternalPlcConsumerRegistration;
import org.apache.plc4x.java.spi.model.InternalPlcSubscriptionHandle;

public class SimulatedConnection
extends AbstractPlcConnection
implements PlcReader,
PlcWriter,
PlcSubscriber {
    private final SimulatedDevice device;
    private boolean connected = false;
    private Map<InternalPlcSubscriptionHandle, InternalPlcConsumerRegistration> registrations = new ConcurrentHashMap<InternalPlcSubscriptionHandle, InternalPlcConsumerRegistration>();
    private Map<Integer, Consumer<PlcSubscriptionEvent>> consumerIdMap = new ConcurrentHashMap<Integer, Consumer<PlcSubscriptionEvent>>();

    public SimulatedConnection(SimulatedDevice device) {
        this.device = device;
    }

    public void connect() {
        this.connected = true;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void close() {
        this.connected = false;
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public boolean canSubscribe() {
        return true;
    }

    public PlcReadRequest.Builder readRequestBuilder() {
        return new DefaultPlcReadRequest.Builder((PlcReader)this, (PlcFieldHandler)new SimulatedFieldHandler());
    }

    public PlcWriteRequest.Builder writeRequestBuilder() {
        return new DefaultPlcWriteRequest.Builder((PlcWriter)this, (PlcFieldHandler)new SimulatedFieldHandler());
    }

    public PlcSubscriptionRequest.Builder subscriptionRequestBuilder() {
        return new DefaultPlcSubscriptionRequest.Builder((PlcSubscriber)this, (PlcFieldHandler)new SimulatedFieldHandler());
    }

    public PlcUnsubscriptionRequest.Builder unsubscriptionRequestBuilder() {
        return new DefaultPlcUnsubscriptionRequest.Builder((PlcSubscriber)this);
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        InternalPlcReadRequest request = (InternalPlcReadRequest)this.checkInternal(readRequest, InternalPlcReadRequest.class);
        HashMap<String, ResponseItem> fields = new HashMap<String, ResponseItem>();
        for (String fieldName : request.getFieldNames()) {
            SimulatedField field = (SimulatedField)request.getField(fieldName);
            Optional<PlcValue> valueOptional = this.device.get(field);
            boolean present = valueOptional.isPresent();
            ResponseItem fieldPair = present ? new ResponseItem(PlcResponseCode.OK, (Object)valueOptional.get()) : new ResponseItem(PlcResponseCode.NOT_FOUND, null);
            fields.put(fieldName, fieldPair);
        }
        DefaultPlcReadResponse response = new DefaultPlcReadResponse(request, fields);
        return CompletableFuture.completedFuture(response);
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        InternalPlcWriteRequest request = (InternalPlcWriteRequest)this.checkInternal(writeRequest, InternalPlcWriteRequest.class);
        HashMap<String, PlcResponseCode> fields = new HashMap<String, PlcResponseCode>();
        for (String fieldName : request.getFieldNames()) {
            SimulatedField field = (SimulatedField)request.getField(fieldName);
            PlcValue value = request.getPlcValue(fieldName);
            this.device.set(field, value);
            fields.put(fieldName, PlcResponseCode.OK);
        }
        DefaultPlcWriteResponse response = new DefaultPlcWriteResponse(request, fields);
        return CompletableFuture.completedFuture(response);
    }

    public String toString() {
        return String.format("simulated:%s", this.device);
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        InternalPlcSubscriptionRequest request = (InternalPlcSubscriptionRequest)this.checkInternal(subscriptionRequest, InternalPlcSubscriptionRequest.class);
        Map subscriptionPlcFieldMap = request.getSubscriptionPlcFieldMap();
        HashMap values = new HashMap();
        subscriptionPlcFieldMap.forEach((name, subscriptionPlcField) -> {
            DefaultPlcSubscriptionHandle handle = new DefaultPlcSubscriptionHandle((PlcSubscriber)this);
            switch (subscriptionPlcField.getPlcSubscriptionType()) {
                case CYCLIC: {
                    this.device.addCyclicSubscription(this.dispatchSubscriptionEvent((String)name, (InternalPlcSubscriptionHandle)handle), (PlcSubscriptionHandle)handle, (SimulatedField)subscriptionPlcField.getPlcField(), (Duration)subscriptionPlcField.getDuration().orElseThrow(RuntimeException::new));
                    break;
                }
                case CHANGE_OF_STATE: {
                    this.device.addChangeOfStateSubscription(this.dispatchSubscriptionEvent((String)name, (InternalPlcSubscriptionHandle)handle), (PlcSubscriptionHandle)handle, (SimulatedField)subscriptionPlcField.getPlcField());
                    break;
                }
                case EVENT: {
                    this.device.addEventSubscription(this.dispatchSubscriptionEvent((String)name, (InternalPlcSubscriptionHandle)handle), (PlcSubscriptionHandle)handle, (SimulatedField)subscriptionPlcField.getPlcField());
                }
            }
            values.put(name, new ResponseItem(PlcResponseCode.OK, (Object)handle));
        });
        DefaultPlcSubscriptionResponse response = new DefaultPlcSubscriptionResponse(request, values);
        return CompletableFuture.completedFuture(response);
    }

    private Consumer<PlcValue> dispatchSubscriptionEvent(String name, InternalPlcSubscriptionHandle handle) {
        return plcValue -> {
            InternalPlcConsumerRegistration plcConsumerRegistration = this.registrations.get(handle);
            if (plcConsumerRegistration == null) {
                return;
            }
            int consumerHash = plcConsumerRegistration.getConsumerHash();
            Consumer<PlcSubscriptionEvent> consumer = this.consumerIdMap.get(consumerHash);
            if (consumer == null) {
                return;
            }
            consumer.accept((PlcSubscriptionEvent)new DefaultPlcSubscriptionEvent(Instant.now(), Collections.singletonMap(name, new ResponseItem(PlcResponseCode.OK, plcValue))));
        };
    }

    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        InternalPlcUnsubscriptionRequest request = (InternalPlcUnsubscriptionRequest)this.checkInternal(unsubscriptionRequest, InternalPlcUnsubscriptionRequest.class);
        this.device.removeHandles(request.getInternalPlcSubscriptionHandles());
        DefaultPlcUnsubscriptionResponse response = new DefaultPlcUnsubscriptionResponse(request);
        return CompletableFuture.completedFuture(response);
    }

    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> handles) {
        DefaultPlcConsumerRegistration plcConsumerRegistration = new DefaultPlcConsumerRegistration((PlcSubscriber)this, consumer, handles.toArray(new InternalPlcSubscriptionHandle[0]));
        handles.stream().map(InternalPlcSubscriptionHandle.class::cast).forEach(arg_0 -> this.lambda$register$2((InternalPlcConsumerRegistration)plcConsumerRegistration, arg_0));
        this.consumerIdMap.put(plcConsumerRegistration.getConsumerHash(), consumer);
        return plcConsumerRegistration;
    }

    public void unregister(PlcConsumerRegistration registration) {
        Iterator<Map.Entry<InternalPlcSubscriptionHandle, InternalPlcConsumerRegistration>> entryIterator = this.registrations.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<InternalPlcSubscriptionHandle, InternalPlcConsumerRegistration> entry = entryIterator.next();
            if (!entry.getValue().equals(registration)) continue;
            InternalPlcConsumerRegistration value = entry.getValue();
            int consumerHash = value.getConsumerHash();
            this.consumerIdMap.remove(consumerHash);
            this.device.removeHandles(value.getAssociatedHandles());
            entryIterator.remove();
        }
    }

    private /* synthetic */ void lambda$register$2(InternalPlcConsumerRegistration plcConsumerRegistration, InternalPlcSubscriptionHandle handle) {
        this.registrations.put(handle, plcConsumerRegistration);
    }
}

