/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.protocol;

import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.opcua.connection.OpcuaTcpPlcConnection;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionEvent;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaMonitoredItem;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class OpcuaSubsriptionHandle
implements PlcSubscriptionHandle {
    private Set<Consumer<PlcSubscriptionEvent>> consumers = new HashSet<Consumer<PlcSubscriptionEvent>>();
    private String fieldName;
    private UInteger clientHandle;

    public OpcuaSubsriptionHandle(String fieldName, UInteger clientHandle) {
        this.fieldName = fieldName;
        this.clientHandle = clientHandle;
    }

    public UInteger getClientHandle() {
        return this.clientHandle;
    }

    public void onSubscriptionValue(UaMonitoredItem item, DataValue value) {
        this.consumers.forEach(plcSubscriptionEventConsumer -> {
            PlcResponseCode resultCode = PlcResponseCode.OK;
            PlcValue stringItem = null;
            if (value.getStatusCode() != StatusCode.GOOD) {
                resultCode = PlcResponseCode.NOT_FOUND;
            } else {
                stringItem = OpcuaTcpPlcConnection.encodePlcValue(value);
            }
            HashMap<String, ResponseItem> fields = new HashMap<String, ResponseItem>();
            ResponseItem newPair = new ResponseItem(resultCode, (Object)stringItem);
            fields.put(this.fieldName, newPair);
            DefaultPlcSubscriptionEvent event = new DefaultPlcSubscriptionEvent(Instant.now(), fields);
            plcSubscriptionEventConsumer.accept(event);
        });
    }

    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer) {
        this.consumers.add(consumer);
        return () -> this.consumers.remove(consumer);
    }
}

