/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.protocol;

import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.value.PlcBigInteger;
import org.apache.plc4x.java.api.value.PlcBoolean;
import org.apache.plc4x.java.api.value.PlcDouble;
import org.apache.plc4x.java.api.value.PlcFloat;
import org.apache.plc4x.java.api.value.PlcInteger;
import org.apache.plc4x.java.api.value.PlcList;
import org.apache.plc4x.java.api.value.PlcLong;
import org.apache.plc4x.java.api.value.PlcString;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.opcua.protocol.OpcuaField;
import org.apache.plc4x.java.spi.connection.DefaultPlcFieldHandler;

public class OpcuaPlcFieldHandler
extends DefaultPlcFieldHandler {
    public PlcField createField(String fieldQuery) {
        if (OpcuaField.matches(fieldQuery)) {
            return OpcuaField.of(fieldQuery);
        }
        throw new PlcInvalidFieldException(fieldQuery);
    }

    public PlcValue encodeString(PlcField field, Object[] values) {
        OpcuaField opcField = (OpcuaField)field;
        ArrayList<String> resultSet = new ArrayList<String>();
        for (Object item : values) {
            resultSet.add(item.toString());
        }
        if (resultSet.size() == 1) {
            return new PlcString((String)resultSet.get(0));
        }
        return new PlcList(resultSet);
    }

    public PlcValue encodeBoolean(PlcField field, Object[] values) {
        OpcuaField opcField = (OpcuaField)field;
        ArrayList<Boolean> resultSet = new ArrayList<Boolean>();
        for (Object item : values) {
            resultSet.add((Boolean)item);
        }
        if (resultSet.size() == 1) {
            return new PlcBoolean((Boolean)resultSet.get(0));
        }
        return new PlcList(resultSet);
    }

    public PlcValue encodeByte(PlcField field, Object[] values) {
        OpcuaField opcField = (OpcuaField)field;
        ArrayList<Byte> resultSet = new ArrayList<Byte>();
        for (Object item : values) {
            resultSet.add((Byte)item);
        }
        if (resultSet.size() == 1) {
            return new PlcInteger((int)((Byte)resultSet.get(0)).byteValue());
        }
        return new PlcList(resultSet);
    }

    public PlcValue encodeShort(PlcField field, Object[] values) {
        OpcuaField opcField = (OpcuaField)field;
        ArrayList<Short> resultSet = new ArrayList<Short>();
        for (Object item : values) {
            resultSet.add((Short)item);
        }
        if (resultSet.size() == 1) {
            return new PlcInteger((int)((Short)resultSet.get(0)).shortValue());
        }
        return new PlcList(resultSet);
    }

    public PlcValue encodeInteger(PlcField field, Object[] values) {
        OpcuaField opcField = (OpcuaField)field;
        ArrayList<Integer> resultSet = new ArrayList<Integer>();
        for (Object item : values) {
            resultSet.add((Integer)item);
        }
        if (resultSet.size() == 1) {
            return new PlcInteger((Integer)resultSet.get(0));
        }
        return new PlcList(resultSet);
    }

    public PlcValue encodeBigInteger(PlcField field, Object[] values) {
        OpcuaField opcField = (OpcuaField)field;
        ArrayList<BigInteger> resultSet = new ArrayList<BigInteger>();
        for (Object item : values) {
            resultSet.add((BigInteger)item);
        }
        if (resultSet.size() == 1) {
            return new PlcBigInteger((BigInteger)resultSet.get(0));
        }
        return new PlcList(resultSet);
    }

    public PlcValue encodeLong(PlcField field, Object[] values) {
        OpcuaField adsField = (OpcuaField)field;
        ArrayList<Long> resultSet = new ArrayList<Long>();
        for (Object item : values) {
            resultSet.add((Long)item);
        }
        if (resultSet.size() == 1) {
            return new PlcLong((Long)resultSet.get(0));
        }
        return new PlcList(resultSet);
    }

    public PlcValue encodeFloat(PlcField field, Object[] values) {
        OpcuaField opcField = (OpcuaField)field;
        ArrayList<Float> resultSet = new ArrayList<Float>();
        for (Object item : values) {
            resultSet.add((Float)item);
        }
        if (resultSet.size() == 1) {
            return new PlcFloat((Float)resultSet.get(0));
        }
        return new PlcList(resultSet);
    }

    public PlcValue encodeDouble(PlcField field, Object[] values) {
        OpcuaField opcField = (OpcuaField)field;
        ArrayList<Double> resultSet = new ArrayList<Double>();
        for (Object item : values) {
            resultSet.add((Double)item);
        }
        if (resultSet.size() == 1) {
            return new PlcDouble((Double)resultSet.get(0));
        }
        return new PlcList(resultSet);
    }
}

