/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.connection;

import java.math.BigInteger;
import java.net.InetAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcBigInteger;
import org.apache.plc4x.java.api.value.PlcBoolean;
import org.apache.plc4x.java.api.value.PlcDouble;
import org.apache.plc4x.java.api.value.PlcFloat;
import org.apache.plc4x.java.api.value.PlcInteger;
import org.apache.plc4x.java.api.value.PlcLong;
import org.apache.plc4x.java.api.value.PlcString;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.opcua.connection.BaseOpcuaPlcConnection;
import org.apache.plc4x.java.opcua.protocol.OpcuaField;
import org.apache.plc4x.java.opcua.protocol.OpcuaSubsriptionHandle;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.InternalPlcReadRequest;
import org.apache.plc4x.java.spi.messages.InternalPlcSubscriptionRequest;
import org.apache.plc4x.java.spi.messages.InternalPlcUnsubscriptionRequest;
import org.apache.plc4x.java.spi.messages.InternalPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.model.SubscriptionPlcField;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfig;
import org.eclipse.milo.opcua.sdk.client.api.identity.AnonymousProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaMonitoredItem;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaSubscription;
import org.eclipse.milo.opcua.stack.client.DiscoveryClient;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringParameters;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcuaTcpPlcConnection
extends BaseOpcuaPlcConnection {
    private static final int OPCUA_DEFAULT_TCP_PORT = 4840;
    private static final Logger logger = LoggerFactory.getLogger(OpcuaTcpPlcConnection.class);
    private final AtomicLong clientHandles = new AtomicLong(1L);
    private InetAddress address;
    private int requestTimeout = 5000;
    private int port;
    private String params;
    private OpcUaClient client;
    private boolean isConnected = false;

    private OpcuaTcpPlcConnection(InetAddress address, String params, int requestTimeout) {
        this(address, 4840, params, requestTimeout);
        logger.info("Configured OpcuaTcpPlcConnection with: host-name {}", (Object)address.getHostAddress());
    }

    private OpcuaTcpPlcConnection(InetAddress address, int port, String params, int requestTimeout) {
        this(params);
        logger.info("Configured OpcuaTcpPlcConnection with: host-name {}", (Object)address.getHostAddress());
        this.address = address;
        this.port = port;
        this.params = params;
        this.requestTimeout = requestTimeout;
    }

    private OpcuaTcpPlcConnection(String params) {
        super(OpcuaTcpPlcConnection.getOptionString(params));
    }

    public static OpcuaTcpPlcConnection of(InetAddress address, String params, int requestTimeout) {
        return new OpcuaTcpPlcConnection(address, params, requestTimeout);
    }

    public static OpcuaTcpPlcConnection of(InetAddress address, int port, String params, int requestTimeout) {
        return new OpcuaTcpPlcConnection(address, port, params, requestTimeout);
    }

    public static PlcValue encodePlcValue(DataValue value) {
        NodeId typeNode = (NodeId)value.getValue().getDataType().get();
        Object objValue = value.getValue().getValue();
        if (typeNode.equals((Object)Identifiers.Boolean)) {
            return new PlcBoolean((Boolean)objValue);
        }
        if (typeNode.equals((Object)Identifiers.Integer)) {
            return new PlcInteger((Integer)objValue);
        }
        if (typeNode.equals((Object)Identifiers.Int16)) {
            return new PlcInteger((int)((Short)objValue).shortValue());
        }
        if (typeNode.equals((Object)Identifiers.Int32)) {
            return new PlcInteger((Integer)objValue);
        }
        if (typeNode.equals((Object)Identifiers.Int64)) {
            return new PlcLong((Long)objValue);
        }
        if (typeNode.equals((Object)Identifiers.UInteger)) {
            return new PlcLong((Long)objValue);
        }
        if (typeNode.equals((Object)Identifiers.UInt16)) {
            return new PlcInteger(((UShort)objValue).intValue());
        }
        if (typeNode.equals((Object)Identifiers.UInt32)) {
            return new PlcLong(((UInteger)objValue).longValue());
        }
        if (typeNode.equals((Object)Identifiers.UInt64)) {
            return new PlcBigInteger(new BigInteger(objValue.toString()));
        }
        if (typeNode.equals((Object)Identifiers.Byte)) {
            return new PlcInteger((int)Short.valueOf(objValue.toString()).shortValue());
        }
        if (typeNode.equals((Object)Identifiers.Float)) {
            return new PlcFloat((Float)objValue);
        }
        if (typeNode.equals((Object)Identifiers.Double)) {
            return new PlcDouble((Double)objValue);
        }
        if (typeNode.equals((Object)Identifiers.SByte)) {
            return new PlcInteger((int)((Byte)objValue).byteValue());
        }
        return new PlcString(objValue.toString());
    }

    public InetAddress getRemoteAddress() {
        return this.address;
    }

    public void connect() throws PlcConnectionException {
        List endpoints = null;
        EndpointDescription endpoint = null;
        try {
            endpoints = (List)DiscoveryClient.getEndpoints((String)this.getEndpointUrl(this.address, this.port, OpcuaTcpPlcConnection.getSubPathOfParams(this.params))).get();
        }
        catch (Exception ex) {
            logger.info("Failed to discover Endpoint with enabled discovery. If the endpoint does not allow a correct discovery disable this option with the nDiscovery=true option. Failed Endpoint: {}", (Object)this.getEndpointUrl(this.address, this.port, this.params));
            String discoveryUrl = this.getEndpointUrl(this.address, this.port, OpcuaTcpPlcConnection.getSubPathOfParams(this.params));
            if (!discoveryUrl.endsWith("/")) {
                discoveryUrl = discoveryUrl + "/";
            }
            discoveryUrl = discoveryUrl + "discovery";
            logger.info("Trying explicit discovery URL: {}", (Object)discoveryUrl);
            try {
                endpoints = (List)DiscoveryClient.getEndpoints((String)discoveryUrl).get();
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
                throw new PlcConnectionException("Unable to discover URL:" + discoveryUrl);
            }
            catch (ExecutionException e3) {
                throw new PlcConnectionException("Unable to discover URL:" + discoveryUrl);
            }
        }
        endpoint = endpoints.stream().filter(e -> e.getSecurityPolicyUri().equals(this.getSecurityPolicy().getUri())).filter(this.endpointFilter()).findFirst().orElseThrow(() -> new PlcConnectionException("No desired endpoints from"));
        if (this.skipDiscovery) {
            EndpointDescription noDiscoverEndpoint;
            ApplicationDescription currentAD = endpoint.getServer();
            ApplicationDescription withoutDiscoveryAD = new ApplicationDescription(currentAD.getApplicationUri(), currentAD.getProductUri(), currentAD.getApplicationName(), currentAD.getApplicationType(), currentAD.getGatewayServerUri(), currentAD.getDiscoveryProfileUri(), new String[0]);
            String newEndpointUrl = endpoint.getEndpointUrl();
            String prefix = "";
            String suffix = "";
            String splitterPrefix = "://";
            String splitterSuffix = ":";
            String[] prefixSplit = newEndpointUrl.split(splitterPrefix);
            if (prefixSplit.length > 1) {
                String[] suffixSplit = prefixSplit[1].split(splitterSuffix);
                newEndpointUrl = "";
                newEndpointUrl = newEndpointUrl + prefixSplit[0] + splitterPrefix + this.address.getHostAddress();
                for (int suffixCounter = 1; suffixCounter < suffixSplit.length; ++suffixCounter) {
                    newEndpointUrl = newEndpointUrl + splitterSuffix + suffixSplit[suffixCounter];
                }
                for (int prefixCounter = 2; prefixCounter < prefixSplit.length; ++prefixCounter) {
                    newEndpointUrl = newEndpointUrl + splitterPrefix + prefixSplit[prefixCounter];
                }
            }
            endpoint = noDiscoverEndpoint = new EndpointDescription(newEndpointUrl, withoutDiscoveryAD, endpoint.getServerCertificate(), endpoint.getSecurityMode(), endpoint.getSecurityPolicyUri(), endpoint.getUserIdentityTokens(), endpoint.getTransportProfileUri(), endpoint.getSecurityLevel());
        }
        OpcUaClientConfig config = OpcUaClientConfig.builder().setApplicationName(LocalizedText.english((String)"eclipse milo opc-ua client of the apache PLC4X:PLC4J project")).setApplicationUri("urn:eclipse:milo:plc4x:client").setEndpoint(endpoint).setIdentityProvider(this.getIdentityProvider()).setRequestTimeout(UInteger.valueOf((int)this.requestTimeout)).build();
        try {
            this.client = OpcUaClient.create((OpcUaClientConfig)config);
            this.client.connect().get();
            this.isConnected = true;
        }
        catch (UaException e4) {
            this.isConnected = false;
            String message = config == null ? "NULL" : config.toString();
            throw new PlcConnectionException("The given input values are a not valid OPC UA connection configuration [CONFIG]: " + message);
        }
        catch (InterruptedException e5) {
            this.isConnected = false;
            Thread.currentThread().interrupt();
            throw new PlcConnectionException("Error while creation of the connection because of : " + e5.getMessage());
        }
        catch (ExecutionException e6) {
            this.isConnected = false;
            throw new PlcConnectionException("Error while creation of the connection because of : " + e6.getMessage());
        }
    }

    public boolean isConnected() {
        return this.client != null && this.isConnected;
    }

    public void close() throws Exception {
        if (this.client != null) {
            this.client.disconnect().get();
            this.isConnected = false;
        }
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        InternalPlcSubscriptionRequest internalPlcSubscriptionRequest = (InternalPlcSubscriptionRequest)this.checkInternal(subscriptionRequest, InternalPlcSubscriptionRequest.class);
        CompletableFuture<PlcSubscriptionResponse> future = CompletableFuture.supplyAsync(() -> {
            Map<String, ResponseItem> responseItems = internalPlcSubscriptionRequest.getSubscriptionPlcFieldMap().entrySet().stream().map(subscriptionPlcFieldEntry -> {
                MonitoringMode monitoringMode;
                String plcFieldName = (String)subscriptionPlcFieldEntry.getKey();
                SubscriptionPlcField subscriptionPlcField = (SubscriptionPlcField)subscriptionPlcFieldEntry.getValue();
                OpcuaField field = (OpcuaField)Objects.requireNonNull(subscriptionPlcField.getPlcField());
                long cycleTime = subscriptionPlcField.getDuration().orElse(Duration.ofSeconds(1L)).toMillis();
                NodeId idNode = this.generateNodeId(field);
                ReadValueId readValueId = new ReadValueId(idNode, AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE);
                UInteger clientHandle = Unsigned.uint((long)this.clientHandles.getAndIncrement());
                MonitoringParameters parameters = new MonitoringParameters(clientHandle, Double.valueOf(cycleTime), null, Unsigned.uint((int)1), Boolean.valueOf(true));
                switch (subscriptionPlcField.getPlcSubscriptionType()) {
                    case CYCLIC: {
                        monitoringMode = MonitoringMode.Sampling;
                        break;
                    }
                    case CHANGE_OF_STATE: {
                        monitoringMode = MonitoringMode.Reporting;
                        break;
                    }
                    case EVENT: {
                        monitoringMode = MonitoringMode.Reporting;
                        break;
                    }
                    default: {
                        monitoringMode = MonitoringMode.Reporting;
                    }
                }
                OpcuaSubsriptionHandle subHandle = null;
                PlcResponseCode responseCode = PlcResponseCode.ACCESS_DENIED;
                try {
                    UaSubscription subscription = (UaSubscription)this.client.getSubscriptionManager().createSubscription((double)cycleTime).get();
                    MonitoredItemCreateRequest request = new MonitoredItemCreateRequest(readValueId, monitoringMode, parameters);
                    LinkedList<MonitoredItemCreateRequest> requestList = new LinkedList<MonitoredItemCreateRequest>();
                    requestList.add(request);
                    OpcuaSubsriptionHandle subsriptionHandle = new OpcuaSubsriptionHandle(plcFieldName, clientHandle);
                    BiConsumer<UaMonitoredItem, Integer> onItemCreated = (item, id) -> item.setValueConsumer(subsriptionHandle::onSubscriptionValue);
                    List items = (List)subscription.createMonitoredItems(TimestampsToReturn.Both, requestList, onItemCreated).get();
                    subHandle = subsriptionHandle;
                    responseCode = PlcResponseCode.OK;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn("Unable to subscribe Elements because of: {}", (Object)e.getMessage());
                }
                catch (ExecutionException e) {
                    logger.warn("Unable to subscribe Elements because of: {}", (Object)e.getMessage());
                }
                return Pair.of((Object)plcFieldName, (Object)new ResponseItem(responseCode, subHandle));
            }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
            return new DefaultPlcSubscriptionResponse(internalPlcSubscriptionRequest, responseItems);
        });
        return future;
    }

    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        InternalPlcUnsubscriptionRequest internalPlcUnsubscriptionRequest = (InternalPlcUnsubscriptionRequest)this.checkInternal(unsubscriptionRequest, InternalPlcUnsubscriptionRequest.class);
        internalPlcUnsubscriptionRequest.getInternalPlcSubscriptionHandles().forEach(o -> {
            OpcuaSubsriptionHandle opcSubHandle = (OpcuaSubsriptionHandle)o;
            try {
                this.client.getSubscriptionManager().deleteSubscription(opcSubHandle.getClientHandle()).get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Unable to unsubscribe Elements because of: {}", (Object)e.getMessage());
            }
            catch (ExecutionException e) {
                logger.warn("Unable to unsubscribe Elements because of: {}", (Object)e.getMessage());
            }
        });
        return null;
    }

    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> handles) {
        LinkedList unregisters = new LinkedList();
        handles.forEach(plcSubscriptionHandle -> unregisters.add(plcSubscriptionHandle.register(consumer)));
        return () -> unregisters.forEach(PlcConsumerRegistration::unregister);
    }

    public void unregister(PlcConsumerRegistration registration) {
        registration.unregister();
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        CompletableFuture<PlcReadResponse> future = CompletableFuture.supplyAsync(() -> {
            readRequest.getFields();
            HashMap<String, ResponseItem> fields = new HashMap<String, ResponseItem>();
            LinkedList<NodeId> readValueIds = new LinkedList<NodeId>();
            List readPLCValues = readRequest.getFields();
            for (PlcField field : readPLCValues) {
                NodeId idNode = this.generateNodeId((OpcuaField)field);
                readValueIds.add(idNode);
            }
            CompletableFuture dataValueCompletableFuture = this.client.readValues(0.0, TimestampsToReturn.Both, readValueIds);
            List readValues = null;
            try {
                readValues = (List)dataValueCompletableFuture.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Unable to read Elements because of: {}", (Object)e.getMessage());
            }
            catch (ExecutionException e) {
                logger.warn("Unable to read Elements because of: {}", (Object)e.getMessage());
            }
            for (int counter = 0; counter < readValueIds.size(); ++counter) {
                PlcResponseCode resultCode = PlcResponseCode.OK;
                PlcValue stringItem = null;
                if (readValues == null || readValues.size() <= counter || !((DataValue)readValues.get(counter)).getStatusCode().equals((Object)StatusCode.GOOD)) {
                    resultCode = PlcResponseCode.NOT_FOUND;
                } else {
                    stringItem = OpcuaTcpPlcConnection.encodePlcValue((DataValue)readValues.get(counter));
                }
                ResponseItem newPair = new ResponseItem(resultCode, stringItem);
                fields.put((String)readRequest.getFieldNames().toArray()[counter], newPair);
            }
            InternalPlcReadRequest internalPlcReadRequest = (InternalPlcReadRequest)this.checkInternal(readRequest, InternalPlcReadRequest.class);
            return new DefaultPlcReadResponse(internalPlcReadRequest, fields);
        });
        return future;
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        CompletableFuture<PlcWriteResponse> future = CompletableFuture.supplyAsync(() -> {
            InternalPlcWriteRequest internalPlcWriteRequest = (InternalPlcWriteRequest)writeRequest;
            List writePLCValues = writeRequest.getFields();
            LinkedList<DataValue> values = new LinkedList<DataValue>();
            LinkedList<NodeId> ids = new LinkedList<NodeId>();
            LinkedList<String> names = new LinkedList<String>();
            HashMap<String, PlcResponseCode> fieldResponse = new HashMap<String, PlcResponseCode>();
            for (String fieldName : writeRequest.getFieldNames()) {
                OpcuaField uaField = (OpcuaField)writeRequest.getField(fieldName);
                NodeId idNode = this.generateNodeId(uaField);
                Object valueObject = internalPlcWriteRequest.getPlcValue(fieldName).getObject();
                if (valueObject instanceof BigInteger) {
                    valueObject = Unsigned.ulong((BigInteger)((BigInteger)valueObject));
                }
                Variant var = new Variant(valueObject);
                DataValue value = new DataValue(var, null, null, null);
                ids.add(idNode);
                names.add(fieldName);
                values.add(value);
            }
            CompletableFuture opcRequest = this.client.writeValues(ids, values);
            LinkedList<StatusCode> statusCodes = null;
            try {
                statusCodes = (LinkedList<StatusCode>)opcRequest.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                statusCodes = new LinkedList();
                for (int counter = 0; counter < ids.size(); ++counter) {
                    statusCodes.push(StatusCode.BAD);
                }
            }
            catch (ExecutionException e) {
                statusCodes = new LinkedList<StatusCode>();
                for (int counter = 0; counter < ids.size(); ++counter) {
                    statusCodes.push(StatusCode.BAD);
                }
            }
            for (int counter = 0; counter < names.size(); ++counter) {
                PlcResponseCode resultCode = statusCodes != null && statusCodes.size() > counter ? (((StatusCode)statusCodes.get(counter)).isGood() ? PlcResponseCode.OK : (((StatusCode)statusCodes.get(counter)).isUncertain() ? PlcResponseCode.NOT_FOUND : (((StatusCode)statusCodes.get(counter)).isBad() && ((StatusCode)statusCodes.get(counter)).getValue() == 2155085824L ? PlcResponseCode.INVALID_DATATYPE : PlcResponseCode.ACCESS_DENIED))) : PlcResponseCode.ACCESS_DENIED;
                fieldResponse.put((String)names.get(counter), resultCode);
            }
            InternalPlcWriteRequest internalPlcReadRequest = (InternalPlcWriteRequest)this.checkInternal(writeRequest, InternalPlcWriteRequest.class);
            DefaultPlcWriteResponse response = new DefaultPlcWriteResponse(internalPlcReadRequest, fieldResponse);
            return response;
        });
        return future;
    }

    private NodeId generateNodeId(OpcuaField uaField) {
        NodeId idNode = null;
        switch (uaField.getIdentifierType()) {
            case STRING_IDENTIFIER: {
                idNode = new NodeId(uaField.getNamespace(), uaField.getIdentifier());
                break;
            }
            case NUMBER_IDENTIFIER: {
                idNode = new NodeId(uaField.getNamespace(), UInteger.valueOf((String)uaField.getIdentifier()));
                break;
            }
            case GUID_IDENTIFIER: {
                idNode = new NodeId(uaField.getNamespace(), UUID.fromString(uaField.getIdentifier()));
                break;
            }
            case BINARY_IDENTIFIER: {
                idNode = new NodeId(uaField.getNamespace(), new ByteString(uaField.getIdentifier().getBytes()));
                break;
            }
            default: {
                idNode = new NodeId(uaField.getNamespace(), uaField.getIdentifier());
            }
        }
        return idNode;
    }

    private String getEndpointUrl(InetAddress address, Integer port, String params) {
        return "opc.tcp://" + address.getHostAddress() + ":" + port + "/" + params;
    }

    private Predicate<EndpointDescription> endpointFilter() {
        return e -> true;
    }

    private SecurityPolicy getSecurityPolicy() {
        return SecurityPolicy.None;
    }

    private IdentityProvider getIdentityProvider() {
        return new AnonymousProvider();
    }

    private static String getSubPathOfParams(String params) {
        if (params.contains("=")) {
            if (params.contains("?")) {
                return params.split("\\?")[0];
            }
            return "";
        }
        return params;
    }

    private static String getOptionString(String params) {
        if (params.contains("=")) {
            if (params.contains("?")) {
                return params.split("\\?")[1];
            }
            return params;
        }
        return "";
    }
}

