/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.connection;

import org.apache.commons.lang3.StringUtils;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.opcua.protocol.OpcuaPlcFieldHandler;
import org.apache.plc4x.java.spi.connection.AbstractPlcConnection;
import org.apache.plc4x.java.spi.connection.PlcFieldHandler;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcUnsubscriptionRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.PlcReader;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.PlcWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOpcuaPlcConnection
extends AbstractPlcConnection
implements PlcReader,
PlcWriter,
PlcSubscriber {
    private static final Logger logger = LoggerFactory.getLogger(BaseOpcuaPlcConnection.class);
    protected boolean skipDiscovery = false;

    BaseOpcuaPlcConnection(String params) {
        if (!StringUtils.isEmpty((CharSequence)params)) {
            for (String param : params.split("&")) {
                String[] paramElements = param.split("=");
                String paramName = paramElements[0];
                if (paramElements.length == 2) {
                    String paramValue = paramElements[1];
                    switch (paramName) {
                        case "discovery": {
                            this.skipDiscovery = Boolean.valueOf(paramValue) == false;
                            break;
                        }
                        default: {
                            logger.debug("Unknown parameter {} with value {}", (Object)paramName, (Object)paramValue);
                            break;
                        }
                    }
                    continue;
                }
                logger.debug("Unknown no-value parameter {}", (Object)paramName);
            }
        }
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public PlcReadRequest.Builder readRequestBuilder() {
        return new DefaultPlcReadRequest.Builder((PlcReader)this, (PlcFieldHandler)new OpcuaPlcFieldHandler());
    }

    public PlcWriteRequest.Builder writeRequestBuilder() {
        return new DefaultPlcWriteRequest.Builder((PlcWriter)this, (PlcFieldHandler)new OpcuaPlcFieldHandler());
    }

    public boolean canSubscribe() {
        return true;
    }

    public PlcSubscriptionRequest.Builder subscriptionRequestBuilder() {
        return new DefaultPlcSubscriptionRequest.Builder((PlcSubscriber)this, (PlcFieldHandler)new OpcuaPlcFieldHandler());
    }

    public PlcUnsubscriptionRequest.Builder unsubscriptionRequestBuilder() {
        return new DefaultPlcUnsubscriptionRequest.Builder((PlcSubscriber)this);
    }

    public boolean isSkipDiscovery() {
        return this.skipDiscovery;
    }
}

