/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.protocol;

import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.base.messages.DefaultPlcSubscriptionEvent;
import org.apache.plc4x.java.base.messages.items.BaseDefaultFieldItem;
import org.apache.plc4x.java.opcua.connection.OpcuaTcpPlcConnection;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaMonitoredItem;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class OpcuaSubsriptionHandle
implements PlcSubscriptionHandle {
    Set<Consumer<PlcSubscriptionEvent>> consumers = new HashSet<Consumer<PlcSubscriptionEvent>>();
    String fieldName;
    UInteger clientHandle;

    public UInteger getClientHandle() {
        return this.clientHandle;
    }

    public OpcuaSubsriptionHandle(String fieldName, UInteger clientHandle) {
        this.clientHandle = clientHandle;
    }

    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer) {
        this.consumers.add(consumer);
        return () -> this.consumers.remove(consumer);
    }

    public void onSubscriptionValue(UaMonitoredItem item, DataValue value) {
        this.consumers.forEach(plcSubscriptionEventConsumer -> {
            PlcResponseCode resultCode = PlcResponseCode.OK;
            BaseDefaultFieldItem stringItem = null;
            if (value.getStatusCode() != StatusCode.GOOD) {
                resultCode = PlcResponseCode.NOT_FOUND;
            } else {
                stringItem = OpcuaTcpPlcConnection.encodeFieldItem(value);
            }
            HashMap<String, ImmutablePair> fields = new HashMap<String, ImmutablePair>();
            ImmutablePair newPair = new ImmutablePair((Object)resultCode, (Object)stringItem);
            fields.put(this.fieldName, newPair);
            DefaultPlcSubscriptionEvent event = new DefaultPlcSubscriptionEvent(Instant.now(), fields);
            plcSubscriptionEventConsumer.accept(event);
        });
    }
}

