/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.protocol;

import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.base.connection.DefaultPlcFieldHandler;
import org.apache.plc4x.java.base.messages.items.BaseDefaultFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultBigIntegerFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultBooleanFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultByteArrayFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultByteFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultDoubleFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultFloatFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultIntegerFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultLongFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultShortFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultStringFieldItem;
import org.apache.plc4x.java.opcua.protocol.OpcuaField;

public class OpcuaPlcFieldHandler
extends DefaultPlcFieldHandler {
    public PlcField createField(String fieldQuery) throws PlcInvalidFieldException {
        if (OpcuaField.matches(fieldQuery)) {
            return OpcuaField.of(fieldQuery);
        }
        throw new PlcInvalidFieldException(fieldQuery);
    }

    public BaseDefaultFieldItem encodeString(PlcField field, Object[] values) {
        OpcuaField adsField = (OpcuaField)field;
        ArrayList<String> resultSet = new ArrayList<String>();
        for (Object item : values) {
            resultSet.add(item.toString());
        }
        return new DefaultStringFieldItem(resultSet.toArray(new String[0]));
    }

    public BaseDefaultFieldItem encodeBoolean(PlcField field, Object[] values) {
        OpcuaField adsField = (OpcuaField)field;
        ArrayList<Boolean> resultSet = new ArrayList<Boolean>();
        for (Object item : values) {
            resultSet.add((Boolean)item);
        }
        return new DefaultBooleanFieldItem(resultSet.toArray(new Boolean[0]));
    }

    public BaseDefaultFieldItem encodeByte(PlcField field, Object[] values) {
        OpcuaField adsField = (OpcuaField)field;
        ArrayList<Byte> resultSet = new ArrayList<Byte>();
        for (Object item : values) {
            resultSet.add((Byte)item);
        }
        return new DefaultByteFieldItem(resultSet.toArray(new Byte[0]));
    }

    public BaseDefaultFieldItem encodeShort(PlcField field, Object[] values) {
        OpcuaField adsField = (OpcuaField)field;
        ArrayList<Short> resultSet = new ArrayList<Short>();
        for (Object item : values) {
            resultSet.add((Short)item);
        }
        return new DefaultShortFieldItem(resultSet.toArray(new Short[0]));
    }

    public BaseDefaultFieldItem encodeInteger(PlcField field, Object[] values) {
        OpcuaField adsField = (OpcuaField)field;
        ArrayList<Integer> resultSet = new ArrayList<Integer>();
        for (Object item : values) {
            resultSet.add((Integer)item);
        }
        return new DefaultIntegerFieldItem(resultSet.toArray(new Integer[0]));
    }

    public BaseDefaultFieldItem encodeBigInteger(PlcField field, Object[] values) {
        OpcuaField adsField = (OpcuaField)field;
        ArrayList<BigInteger> resultSet = new ArrayList<BigInteger>();
        for (Object item : values) {
            resultSet.add((BigInteger)item);
        }
        return new DefaultBigIntegerFieldItem(resultSet.toArray(new BigInteger[0]));
    }

    public BaseDefaultFieldItem encodeLong(PlcField field, Object[] values) {
        OpcuaField adsField = (OpcuaField)field;
        ArrayList<Long> resultSet = new ArrayList<Long>();
        for (Object item : values) {
            resultSet.add((Long)item);
        }
        return new DefaultLongFieldItem(resultSet.toArray(new Long[0]));
    }

    public BaseDefaultFieldItem encodeFloat(PlcField field, Object[] values) {
        OpcuaField adsField = (OpcuaField)field;
        ArrayList<Float> resultSet = new ArrayList<Float>();
        for (Object item : values) {
            resultSet.add((Float)item);
        }
        return new DefaultFloatFieldItem(resultSet.toArray(new Float[0]));
    }

    public BaseDefaultFieldItem encodeDouble(PlcField field, Object[] values) {
        OpcuaField adsField = (OpcuaField)field;
        ArrayList<Double> resultSet = new ArrayList<Double>();
        for (Object item : values) {
            resultSet.add((Double)item);
        }
        return new DefaultDoubleFieldItem(resultSet.toArray(new Double[0]));
    }

    public BaseDefaultFieldItem encodeByteArray(PlcField field, Object[] values) {
        OpcuaField adsField = (OpcuaField)field;
        Byte[][] byteArray = new Byte[values.length][];
        int innerCounter = 0;
        for (Object item : values) {
            byte[] itemArray = (byte[])item;
            byteArray[innerCounter] = new Byte[((byte[])item).length];
            for (int counter = 0; counter < itemArray.length; ++counter) {
                byteArray[innerCounter][counter] = itemArray[counter];
            }
            ++innerCounter;
        }
        return new DefaultByteArrayFieldItem(byteArray);
    }
}

