/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.protocol;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.opcua.protocol.model.OpcuaIdentifierType;

public class OpcuaField
implements PlcField {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("^ns=(?<namespace>\\d+);((?<identifierType>[isgb])=((?<identifier>[\\w.\\-/=%_]+))?)");
    private final OpcuaIdentifierType identifierType;
    private final int namespace;
    private final String identifier;

    protected OpcuaField(int namespace, OpcuaIdentifierType identifierType, String identifier) {
        this.namespace = namespace;
        this.identifier = identifier;
        this.identifierType = identifierType;
        if (this.identifier == null || this.namespace < 0) {
            throw new IllegalArgumentException("Identifier can not be null or Namespace can not be lower then 0.");
        }
    }

    private OpcuaField(Integer namespace, String identifier, OpcuaIdentifierType identifierType) {
        this.identifier = Objects.requireNonNull(identifier);
        this.identifierType = Objects.requireNonNull(identifierType);
        int n = this.namespace = namespace != null ? namespace : 0;
        if (this.namespace < 0) {
            throw new IllegalArgumentException("namespace must be greater then zero. Was " + this.namespace);
        }
    }

    public static OpcuaField of(String address) {
        Matcher matcher = ADDRESS_PATTERN.matcher(address);
        if (!matcher.matches()) {
            throw new PlcInvalidFieldException(address, ADDRESS_PATTERN, "{address}");
        }
        String identifier = matcher.group("identifier");
        String identifierTypeString = matcher.group("identifierType");
        OpcuaIdentifierType identifierType = OpcuaIdentifierType.fromString(identifierTypeString);
        String namespaceString = matcher.group("namespace");
        Integer namespace = namespaceString != null ? Integer.valueOf(namespaceString) : 0;
        return new OpcuaField(namespace, identifier, identifierType);
    }

    public static boolean matches(String address) {
        return ADDRESS_PATTERN.matcher(address).matches();
    }

    public int getNamespace() {
        return this.namespace;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public OpcuaIdentifierType getIdentifierType() {
        return this.identifierType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpcuaField)) {
            return false;
        }
        OpcuaField that = (OpcuaField)o;
        return this.namespace == that.namespace && this.identifier.equals(that.identifier) && this.identifierType == that.identifierType;
    }

    public int hashCode() {
        return Objects.hash(this.namespace);
    }

    public String toString() {
        return "OpcuaField{namespace=" + this.namespace + "identifierType=" + this.identifierType.getText() + "identifier=" + this.identifier + '}';
    }
}

