/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.connection;

import java.math.BigInteger;
import java.net.InetAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.base.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.base.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.base.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.base.messages.InternalPlcReadRequest;
import org.apache.plc4x.java.base.messages.InternalPlcSubscriptionRequest;
import org.apache.plc4x.java.base.messages.InternalPlcUnsubscriptionRequest;
import org.apache.plc4x.java.base.messages.InternalPlcWriteRequest;
import org.apache.plc4x.java.base.messages.items.BaseDefaultFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultBigIntegerFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultBooleanFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultByteArrayFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultByteFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultDoubleFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultFloatFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultIntegerFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultLongFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultShortFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultStringFieldItem;
import org.apache.plc4x.java.base.model.SubscriptionPlcField;
import org.apache.plc4x.java.opcua.connection.BaseOpcuaPlcConnection;
import org.apache.plc4x.java.opcua.protocol.OpcuaField;
import org.apache.plc4x.java.opcua.protocol.OpcuaSubsriptionHandle;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfig;
import org.eclipse.milo.opcua.sdk.client.api.identity.AnonymousProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaMonitoredItem;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaSubscription;
import org.eclipse.milo.opcua.stack.client.DiscoveryClient;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringParameters;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcuaTcpPlcConnection
extends BaseOpcuaPlcConnection {
    private static final int OPCUA_DEFAULT_TCP_PORT = 4840;
    private static final Logger logger = LoggerFactory.getLogger(OpcuaTcpPlcConnection.class);
    private InetAddress address;
    private int requestTimeout = 5000;
    private int port;
    private String params;
    private OpcUaClient client;
    private boolean isConnected = false;
    private final AtomicLong clientHandles = new AtomicLong(1L);

    private OpcuaTcpPlcConnection(InetAddress address, String params, int requestTimeout) {
        this(address, 4840, params, requestTimeout);
        logger.info("Configured OpcuaTcpPlcConnection with: host-name {}", (Object)address.getHostAddress());
    }

    public OpcuaTcpPlcConnection(InetAddress address, int port, String params, int requestTimeout) {
        this(params);
        logger.info("Configured OpcuaTcpPlcConnection with: host-name {}", (Object)address.getHostAddress());
        this.address = address;
        this.port = port;
        this.params = params;
        this.requestTimeout = requestTimeout;
    }

    public OpcuaTcpPlcConnection(String params) {
        super(params);
    }

    public static OpcuaTcpPlcConnection of(InetAddress address, String params, int requestTimeout) {
        return new OpcuaTcpPlcConnection(address, params, requestTimeout);
    }

    public static OpcuaTcpPlcConnection of(InetAddress address, int port, String params, int requestTimeout) {
        return new OpcuaTcpPlcConnection(address, port, params, requestTimeout);
    }

    public static BaseDefaultFieldItem encodeFieldItem(DataValue value) {
        NodeId typeNode = (NodeId)value.getValue().getDataType().get();
        Object objValue = value.getValue().getValue();
        if (typeNode.equals((Object)Identifiers.Boolean)) {
            return new DefaultBooleanFieldItem(new Boolean[]{(Boolean)objValue});
        }
        if (typeNode.equals((Object)Identifiers.ByteString)) {
            byte[] array = ((ByteString)objValue).bytes();
            Byte[] byteArry = new Byte[array.length];
            int counter = 0;
            for (byte bytie : array) {
                byteArry[counter] = bytie;
                ++counter;
            }
            return new DefaultByteArrayFieldItem((Byte[][])new Byte[][]{byteArry});
        }
        if (typeNode.equals((Object)Identifiers.Integer)) {
            return new DefaultIntegerFieldItem(new Integer[]{(Integer)objValue});
        }
        if (typeNode.equals((Object)Identifiers.Int16)) {
            return new DefaultShortFieldItem(new Short[]{(Short)objValue});
        }
        if (typeNode.equals((Object)Identifiers.Int32)) {
            return new DefaultIntegerFieldItem(new Integer[]{(Integer)objValue});
        }
        if (typeNode.equals((Object)Identifiers.Int64)) {
            return new DefaultLongFieldItem(new Long[]{(Long)objValue});
        }
        if (typeNode.equals((Object)Identifiers.UInteger)) {
            return new DefaultLongFieldItem(new Long[]{(Long)objValue});
        }
        if (typeNode.equals((Object)Identifiers.UInt16)) {
            return new DefaultIntegerFieldItem(new Integer[]{((UShort)objValue).intValue()});
        }
        if (typeNode.equals((Object)Identifiers.UInt32)) {
            return new DefaultLongFieldItem(new Long[]{((UInteger)objValue).longValue()});
        }
        if (typeNode.equals((Object)Identifiers.UInt64)) {
            return new DefaultBigIntegerFieldItem(new BigInteger[]{new BigInteger(objValue.toString())});
        }
        if (typeNode.equals((Object)Identifiers.Byte)) {
            return new DefaultShortFieldItem(new Short[]{Short.valueOf(objValue.toString())});
        }
        if (typeNode.equals((Object)Identifiers.Float)) {
            return new DefaultFloatFieldItem(new Float[]{(Float)objValue});
        }
        if (typeNode.equals((Object)Identifiers.Double)) {
            return new DefaultDoubleFieldItem(new Double[]{(Double)objValue});
        }
        if (typeNode.equals((Object)Identifiers.SByte)) {
            return new DefaultByteFieldItem(new Byte[]{(Byte)objValue});
        }
        return new DefaultStringFieldItem(new String[]{objValue.toString()});
    }

    public InetAddress getRemoteAddress() {
        return this.address;
    }

    public void connect() throws PlcConnectionException {
        List endpoints = null;
        try {
            endpoints = (List)DiscoveryClient.getEndpoints((String)this.getEndpointUrl(this.address, this.port, this.params)).get();
        }
        catch (Exception ex) {
            String discoveryUrl = this.getEndpointUrl(this.address, this.port, this.params);
            if (!discoveryUrl.endsWith("/")) {
                discoveryUrl = discoveryUrl + "/";
            }
            discoveryUrl = discoveryUrl + "discovery";
            logger.info("Trying explicit discovery URL: {}", (Object)discoveryUrl);
            try {
                endpoints = (List)DiscoveryClient.getEndpoints((String)discoveryUrl).get();
            }
            catch (InterruptedException | ExecutionException e2) {
                throw new PlcConnectionException("Unable to discover URL:" + discoveryUrl);
            }
        }
        EndpointDescription endpoint = endpoints.stream().filter(e -> e.getSecurityPolicyUri().equals(this.getSecurityPolicy().getUri())).filter(this.endpointFilter()).findFirst().orElseThrow(() -> new PlcConnectionException("No desired endpoints from"));
        OpcUaClientConfig config = OpcUaClientConfig.builder().setApplicationName(LocalizedText.english((String)"eclipse milo opc-ua client of the apache PLC4X:PLC4J project")).setApplicationUri("urn:eclipse:milo:plc4x:client").setEndpoint(endpoint).setIdentityProvider(this.getIdentityProvider()).setRequestTimeout(UInteger.valueOf((int)this.requestTimeout)).build();
        try {
            this.client = OpcUaClient.create((OpcUaClientConfig)config);
            this.client.connect().get();
            this.isConnected = true;
        }
        catch (UaException e3) {
            this.isConnected = false;
            String message = config == null ? "NULL" : config.toString();
            throw new PlcConnectionException("The given input values are a not valid OPC UA connection configuration [CONFIG]: " + message);
        }
        catch (InterruptedException | ExecutionException e4) {
            this.isConnected = false;
            throw new PlcConnectionException("Error while creation of the connection because of : " + e4.getMessage());
        }
    }

    public boolean isConnected() {
        return this.client != null && this.isConnected;
    }

    public void close() throws Exception {
        if (this.client != null) {
            this.client.disconnect().get();
            this.isConnected = false;
        }
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        InternalPlcSubscriptionRequest internalPlcSubscriptionRequest = (InternalPlcSubscriptionRequest)this.checkInternal(subscriptionRequest, InternalPlcSubscriptionRequest.class);
        CompletableFuture<PlcSubscriptionResponse> future = CompletableFuture.supplyAsync(() -> {
            Map<String, Pair> responseItems = internalPlcSubscriptionRequest.getSubscriptionPlcFieldMap().entrySet().stream().map(subscriptionPlcFieldEntry -> {
                MonitoringMode monitoringMode;
                String plcFieldName = (String)subscriptionPlcFieldEntry.getKey();
                SubscriptionPlcField subscriptionPlcField = (SubscriptionPlcField)subscriptionPlcFieldEntry.getValue();
                OpcuaField field = (OpcuaField)Objects.requireNonNull(subscriptionPlcField.getPlcField());
                long cycleTime = subscriptionPlcField.getDuration().orElse(Duration.ofSeconds(1L)).toMillis();
                NodeId idNode = this.generateNodeId(field);
                ReadValueId readValueId = new ReadValueId(idNode, AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE);
                UInteger clientHandle = Unsigned.uint((long)this.clientHandles.getAndIncrement());
                MonitoringParameters parameters = new MonitoringParameters(clientHandle, Double.valueOf(cycleTime), null, Unsigned.uint((int)1), Boolean.valueOf(true));
                switch (subscriptionPlcField.getPlcSubscriptionType()) {
                    case CYCLIC: {
                        monitoringMode = MonitoringMode.Sampling;
                        break;
                    }
                    case CHANGE_OF_STATE: {
                        monitoringMode = MonitoringMode.Reporting;
                        break;
                    }
                    case EVENT: {
                        monitoringMode = MonitoringMode.Reporting;
                        break;
                    }
                    default: {
                        monitoringMode = MonitoringMode.Reporting;
                    }
                }
                OpcuaSubsriptionHandle subHandle = null;
                PlcResponseCode responseCode = PlcResponseCode.ACCESS_DENIED;
                try {
                    UaSubscription subscription = (UaSubscription)this.client.getSubscriptionManager().createSubscription(1000.0).get();
                    MonitoredItemCreateRequest request = new MonitoredItemCreateRequest(readValueId, monitoringMode, parameters);
                    LinkedList<MonitoredItemCreateRequest> requestList = new LinkedList<MonitoredItemCreateRequest>();
                    requestList.add(request);
                    OpcuaSubsriptionHandle subsriptionHandle = new OpcuaSubsriptionHandle(plcFieldName, clientHandle);
                    BiConsumer<UaMonitoredItem, Integer> onItemCreated = (item, id) -> item.setValueConsumer(subsriptionHandle::onSubscriptionValue);
                    List items = (List)subscription.createMonitoredItems(TimestampsToReturn.Both, requestList, onItemCreated).get();
                    subHandle = subsriptionHandle;
                    responseCode = PlcResponseCode.OK;
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.warn("Unable to subscribe Elements because of: {}", (Object)e.getMessage());
                }
                return Pair.of((Object)plcFieldName, (Object)Pair.of((Object)responseCode, subHandle));
            }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
            return new DefaultPlcSubscriptionResponse(internalPlcSubscriptionRequest, responseItems);
        });
        return future;
    }

    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        InternalPlcUnsubscriptionRequest internalPlcUnsubscriptionRequest = (InternalPlcUnsubscriptionRequest)this.checkInternal(unsubscriptionRequest, InternalPlcUnsubscriptionRequest.class);
        internalPlcUnsubscriptionRequest.getInternalPlcSubscriptionHandles().forEach(o -> {
            OpcuaSubsriptionHandle opcSubHandle = (OpcuaSubsriptionHandle)o;
            try {
                this.client.getSubscriptionManager().deleteSubscription(opcSubHandle.getClientHandle()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.warn("Unable to unsubscribe Elements because of: {}", (Object)e.getMessage());
            }
        });
        return null;
    }

    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> handles) {
        LinkedList unregisters = new LinkedList();
        handles.forEach(plcSubscriptionHandle -> unregisters.add(plcSubscriptionHandle.register(consumer)));
        return () -> unregisters.forEach(PlcConsumerRegistration::unregister);
    }

    public void unregister(PlcConsumerRegistration registration) {
        registration.unregister();
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        CompletableFuture<PlcReadResponse> future = CompletableFuture.supplyAsync(() -> {
            readRequest.getFields();
            HashMap<String, ImmutablePair> fields = new HashMap<String, ImmutablePair>();
            LinkedList<NodeId> readValueIds = new LinkedList<NodeId>();
            List readPLCValues = readRequest.getFields();
            for (PlcField field : readPLCValues) {
                NodeId idNode = this.generateNodeId((OpcuaField)field);
                readValueIds.add(idNode);
            }
            CompletableFuture dataValueCompletableFuture = this.client.readValues(0.0, TimestampsToReturn.Both, readValueIds);
            List readValues = null;
            try {
                readValues = (List)dataValueCompletableFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.warn("Unable to read Elements because of: {}", (Object)e.getMessage());
            }
            for (int counter = 0; counter < readValueIds.size(); ++counter) {
                PlcResponseCode resultCode = PlcResponseCode.OK;
                BaseDefaultFieldItem stringItem = null;
                if (readValues == null || readValues.size() <= counter || ((DataValue)readValues.get(counter)).getStatusCode() != StatusCode.GOOD) {
                    resultCode = PlcResponseCode.NOT_FOUND;
                } else {
                    stringItem = OpcuaTcpPlcConnection.encodeFieldItem((DataValue)readValues.get(counter));
                }
                ImmutablePair newPair = new ImmutablePair((Object)resultCode, stringItem);
                fields.put((String)readRequest.getFieldNames().toArray()[counter], newPair);
            }
            InternalPlcReadRequest internalPlcReadRequest = (InternalPlcReadRequest)this.checkInternal(readRequest, InternalPlcReadRequest.class);
            return new DefaultPlcReadResponse(internalPlcReadRequest, fields);
        });
        return future;
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        CompletableFuture<PlcWriteResponse> future = CompletableFuture.supplyAsync(() -> {
            InternalPlcWriteRequest internalPlcWriteRequest = (InternalPlcWriteRequest)writeRequest;
            List writePLCValues = writeRequest.getFields();
            LinkedList<DataValue> values = new LinkedList<DataValue>();
            LinkedList<NodeId> ids = new LinkedList<NodeId>();
            LinkedList<String> names = new LinkedList<String>();
            HashMap fieldResponse = new HashMap();
            for (String fieldName : writeRequest.getFieldNames()) {
                OpcuaField uaField = (OpcuaField)writeRequest.getField(fieldName);
                NodeId idNode = this.generateNodeId(uaField);
                Variant var = new Variant(internalPlcWriteRequest.getFieldItem(fieldName).getObject(0));
                DataValue value = new DataValue(var, null, null);
                ids.add(idNode);
                names.add(fieldName);
                values.add(value);
            }
            CompletableFuture opcRequest = this.client.writeValues(ids, values);
            LinkedList<StatusCode> statusCodes = null;
            try {
                statusCodes = (LinkedList<StatusCode>)opcRequest.get();
            }
            catch (InterruptedException | ExecutionException e) {
                statusCodes = new LinkedList<StatusCode>();
                for (int counter = 0; counter < ids.size(); ++counter) {
                    statusCodes.push(StatusCode.BAD);
                }
            }
            for (int counter = 0; counter < names.size(); ++counter) {
                PlcResponseCode resultCode = statusCodes != null && statusCodes.size() > counter ? (((StatusCode)statusCodes.get(counter)).isGood() ? PlcResponseCode.OK : (((StatusCode)statusCodes.get(counter)).isUncertain() ? PlcResponseCode.NOT_FOUND : PlcResponseCode.ACCESS_DENIED)) : PlcResponseCode.ACCESS_DENIED;
                fieldResponse.put(names.get(counter), resultCode);
            }
            InternalPlcWriteRequest internalPlcReadRequest = (InternalPlcWriteRequest)this.checkInternal(writeRequest, InternalPlcWriteRequest.class);
            DefaultPlcWriteResponse response = new DefaultPlcWriteResponse(internalPlcReadRequest, fieldResponse);
            return response;
        });
        return future;
    }

    private NodeId generateNodeId(OpcuaField uaField) {
        NodeId idNode = null;
        switch (uaField.getIdentifierType()) {
            case STRING_IDENTIFIER: {
                idNode = new NodeId(uaField.getNamespace(), uaField.getIdentifier());
                break;
            }
            case NUMBER_IDENTIFIER: {
                idNode = new NodeId(uaField.getNamespace(), UInteger.valueOf((String)uaField.getIdentifier()));
                break;
            }
            case GUID_IDENTIFIER: {
                idNode = new NodeId(uaField.getNamespace(), UUID.fromString(uaField.getIdentifier()));
                break;
            }
            case BINARY_IDENTIFIER: {
                idNode = new NodeId(uaField.getNamespace(), new ByteString(uaField.getIdentifier().getBytes()));
                break;
            }
            default: {
                idNode = new NodeId(uaField.getNamespace(), uaField.getIdentifier());
            }
        }
        return idNode;
    }

    private String getEndpointUrl(InetAddress address, Integer port, String params) {
        return "opc.tcp://" + address.getHostAddress() + ":" + port + "/" + params;
    }

    private Predicate<EndpointDescription> endpointFilter() {
        return e -> true;
    }

    private SecurityPolicy getSecurityPolicy() {
        return SecurityPolicy.None;
    }

    private IdentityProvider getIdentityProvider() {
        return new AnonymousProvider();
    }
}

