/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.opcua.connection.OpcuaConnectionFactory;
import org.apache.plc4x.java.spi.PlcDriver;

public class OpcuaPlcDriver
implements PlcDriver {
    public static final Pattern INET_ADDRESS_PATTERN = Pattern.compile("tcp://(?<host>[\\w.-]+)(:(?<port>\\d*))?");
    public static final Pattern OPCUA_URI_PATTERN = Pattern.compile("^opcua:(" + INET_ADDRESS_PATTERN + ")?(?<params>/[\\w/]+)?");
    private static final int requestTimeout = 10000;
    private OpcuaConnectionFactory opcuaConnectionFactory;

    public OpcuaPlcDriver() {
        this.opcuaConnectionFactory = new OpcuaConnectionFactory();
    }

    public OpcuaPlcDriver(OpcuaConnectionFactory opcuaConnectionFactory) {
        this.opcuaConnectionFactory = opcuaConnectionFactory;
    }

    public String getProtocolCode() {
        return "opcua";
    }

    public String getProtocolName() {
        return "OPC UA (TCP)";
    }

    public PlcConnection connect(String url) throws PlcConnectionException {
        Matcher matcher = OPCUA_URI_PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new PlcConnectionException("Connection url doesn't match the format 'opcua:{type}//{port|host}'");
        }
        String host = matcher.group("host");
        String portString = matcher.group("port");
        Integer port = StringUtils.isNotBlank((CharSequence)portString) ? Integer.valueOf(Integer.parseInt(portString)) : null;
        String params = matcher.group("params") != null ? matcher.group("params").substring(1) : null;
        try {
            return this.opcuaConnectionFactory.opcuaTcpPlcConnectionOf(InetAddress.getByName(host), port, params, 10000);
        }
        catch (UnknownHostException e) {
            throw new PlcConnectionException((Throwable)e);
        }
    }

    public PlcConnection connect(String url, PlcAuthentication authentication) throws PlcConnectionException {
        throw new PlcConnectionException("opcua does not support Auth at this state");
    }
}

