/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite.io;

import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.modbus.readwrite.ModbusTcpADU;
import org.apache.plc4x.java.modbus.readwrite.io.ModbusPDUIO;
import org.apache.plc4x.java.spi.generation.MessageIO;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusTcpADUIO
implements MessageIO<ModbusTcpADU, ModbusTcpADU> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModbusTcpADUIO.class);

    public ModbusTcpADU parse(ReadBuffer io, Object ... args) throws ParseException {
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (!(args[0] instanceof Boolean)) {
            throw new PlcRuntimeException("Argument 0 expected to be of type Boolean but was " + args[0].getClass().getName());
        }
        Boolean response = (Boolean)args[0];
        return ModbusTcpADUIO.staticParse(io, response);
    }

    public void serialize(WriteBuffer io, ModbusTcpADU value, Object ... args) throws ParseException {
        ModbusTcpADUIO.staticSerialize(io, value);
    }

    public static ModbusTcpADU staticParse(ReadBuffer io, Boolean response) throws ParseException {
        int startPos = io.getPos();
        int transactionIdentifier = io.readUnsignedInt(16);
        int protocolIdentifier = io.readUnsignedInt(16);
        if (protocolIdentifier != 0) {
            throw new ParseException("Expected constant value 0 but got " + protocolIdentifier);
        }
        int length = io.readUnsignedInt(16);
        short unitIdentifier = io.readUnsignedShort(8);
        ModbusPDU pdu = ModbusPDUIO.staticParse(io, (boolean)response);
        return new ModbusTcpADU(transactionIdentifier, unitIdentifier, pdu);
    }

    public static void staticSerialize(WriteBuffer io, ModbusTcpADU _value) throws ParseException {
        int startPos = io.getPos();
        int transactionIdentifier = _value.getTransactionIdentifier();
        io.writeUnsignedInt(16, ((Number)transactionIdentifier).intValue());
        io.writeUnsignedInt(16, ((Number)0).intValue());
        int length = _value.getPdu().getLengthInBytes() + 1;
        io.writeUnsignedInt(16, ((Number)length).intValue());
        short unitIdentifier = _value.getUnitIdentifier();
        io.writeUnsignedShort(8, ((Number)unitIdentifier).shortValue());
        ModbusPDU pdu = _value.getPdu();
        ModbusPDUIO.staticSerialize(io, pdu);
    }
}

