/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite.io;

import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.modbus.readwrite.ModbusSerialADU;
import org.apache.plc4x.java.modbus.readwrite.io.ModbusPDUIO;
import org.apache.plc4x.java.spi.generation.MessageIO;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusSerialADUIO
implements MessageIO<ModbusSerialADU, ModbusSerialADU> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModbusSerialADUIO.class);

    public ModbusSerialADU parse(ReadBuffer io, Object ... args) throws ParseException {
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (!(args[0] instanceof Boolean)) {
            throw new PlcRuntimeException("Argument 0 expected to be of type Boolean but was " + args[0].getClass().getName());
        }
        Boolean response = (Boolean)args[0];
        return ModbusSerialADUIO.staticParse(io, response);
    }

    public void serialize(WriteBuffer io, ModbusSerialADU value, Object ... args) throws ParseException {
        ModbusSerialADUIO.staticSerialize(io, value);
    }

    public static ModbusSerialADU staticParse(ReadBuffer io, Boolean response) throws ParseException {
        int startPos = io.getPos();
        int transactionId = io.readUnsignedInt(16);
        int reserved = io.readUnsignedInt(16);
        if (reserved != 0) {
            LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
        }
        int length = io.readUnsignedInt(16);
        short address = io.readUnsignedShort(8);
        ModbusPDU pdu = ModbusPDUIO.staticParse(io, (boolean)response);
        return new ModbusSerialADU(transactionId, length, address, pdu);
    }

    public static void staticSerialize(WriteBuffer io, ModbusSerialADU _value) throws ParseException {
        int startPos = io.getPos();
        int transactionId = _value.getTransactionId();
        io.writeUnsignedInt(16, ((Number)transactionId).intValue());
        io.writeUnsignedInt(16, ((Number)0).intValue());
        int length = _value.getLength();
        io.writeUnsignedInt(16, ((Number)length).intValue());
        short address = _value.getAddress();
        io.writeUnsignedShort(8, ((Number)address).shortValue());
        ModbusPDU pdu = _value.getPdu();
        ModbusPDUIO.staticSerialize(io, pdu);
    }
}

