/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite.io;

import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteMultipleHoldingRegistersRequest;
import org.apache.plc4x.java.modbus.readwrite.io.ModbusPDUIO;
import org.apache.plc4x.java.spi.generation.MessageIO;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusPDUWriteMultipleHoldingRegistersRequestIO
implements MessageIO<ModbusPDUWriteMultipleHoldingRegistersRequest, ModbusPDUWriteMultipleHoldingRegistersRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModbusPDUWriteMultipleHoldingRegistersRequestIO.class);

    public ModbusPDUWriteMultipleHoldingRegistersRequest parse(ReadBuffer io, Object ... args) throws ParseException {
        return (ModbusPDUWriteMultipleHoldingRegistersRequest)new ModbusPDUIO().parse(io, args);
    }

    public void serialize(WriteBuffer io, ModbusPDUWriteMultipleHoldingRegistersRequest value, Object ... args) throws ParseException {
        new ModbusPDUIO().serialize(io, value, args);
    }

    public static ModbusPDUWriteMultipleHoldingRegistersRequestBuilder staticParse(ReadBuffer io, Boolean response) throws ParseException {
        int startPos = io.getPos();
        int startingAddress = io.readUnsignedInt(16);
        int quantity = io.readUnsignedInt(16);
        int byteCount = io.readUnsignedShort(8);
        if (byteCount > Integer.MAX_VALUE) {
            throw new ParseException("Array count of " + byteCount + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
        }
        int itemCount = byteCount;
        byte[] value = new byte[itemCount];
        for (int curItem = 0; curItem < itemCount; ++curItem) {
            value[curItem] = io.readByte(8);
        }
        return new ModbusPDUWriteMultipleHoldingRegistersRequestBuilder(startingAddress, quantity, value);
    }

    public static void staticSerialize(WriteBuffer io, ModbusPDUWriteMultipleHoldingRegistersRequest _value) throws ParseException {
        int startPos = io.getPos();
        int startingAddress = _value.getStartingAddress();
        io.writeUnsignedInt(16, ((Number)startingAddress).intValue());
        int quantity = _value.getQuantity();
        io.writeUnsignedInt(16, ((Number)quantity).intValue());
        short byteCount = (short)StaticHelper.COUNT((Object)_value.getValue());
        io.writeUnsignedShort(8, ((Number)byteCount).shortValue());
        if (_value.getValue() != null) {
            int itemCount = _value.getValue().length;
            int curItem = 0;
            for (byte element : _value.getValue()) {
                io.writeByte(8, ((Number)element).byteValue());
                ++curItem;
            }
        }
    }

    public static class ModbusPDUWriteMultipleHoldingRegistersRequestBuilder
    implements ModbusPDUIO.ModbusPDUBuilder {
        private final int startingAddress;
        private final int quantity;
        private final byte[] value;

        public ModbusPDUWriteMultipleHoldingRegistersRequestBuilder(int startingAddress, int quantity, byte[] value) {
            this.startingAddress = startingAddress;
            this.quantity = quantity;
            this.value = value;
        }

        @Override
        public ModbusPDUWriteMultipleHoldingRegistersRequest build() {
            return new ModbusPDUWriteMultipleHoldingRegistersRequest(this.startingAddress, this.quantity, this.value);
        }
    }
}

