/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite.io;

import java.util.LinkedList;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteFileRecordRequestItem;
import org.apache.plc4x.java.spi.generation.MessageIO;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusPDUWriteFileRecordRequestItemIO
implements MessageIO<ModbusPDUWriteFileRecordRequestItem, ModbusPDUWriteFileRecordRequestItem> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModbusPDUWriteFileRecordRequestItemIO.class);

    public ModbusPDUWriteFileRecordRequestItem parse(ReadBuffer io, Object ... args) throws ParseException {
        return ModbusPDUWriteFileRecordRequestItemIO.staticParse(io);
    }

    public void serialize(WriteBuffer io, ModbusPDUWriteFileRecordRequestItem value, Object ... args) throws ParseException {
        ModbusPDUWriteFileRecordRequestItemIO.staticSerialize(io, value);
    }

    public static ModbusPDUWriteFileRecordRequestItem staticParse(ReadBuffer io) throws ParseException {
        int startPos = io.getPos();
        short referenceType = io.readUnsignedShort(8);
        int fileNumber = io.readUnsignedInt(16);
        int recordNumber = io.readUnsignedInt(16);
        int recordLength = io.readUnsignedInt(16);
        int _recordDataLength = recordLength * 2;
        LinkedList<Integer> _recordDataList = new LinkedList<Integer>();
        int recordDataEndPos = io.getPos() + _recordDataLength;
        while (io.getPos() < recordDataEndPos) {
            _recordDataList.add(io.readUnsignedInt(16));
        }
        int[] recordData = new int[_recordDataList.size()];
        for (int i = 0; i < _recordDataList.size(); ++i) {
            recordData[i] = (Integer)_recordDataList.get(i);
        }
        return new ModbusPDUWriteFileRecordRequestItem(referenceType, fileNumber, recordNumber, recordData);
    }

    public static void staticSerialize(WriteBuffer io, ModbusPDUWriteFileRecordRequestItem _value) throws ParseException {
        int startPos = io.getPos();
        short referenceType = _value.getReferenceType();
        io.writeUnsignedShort(8, ((Number)referenceType).shortValue());
        int fileNumber = _value.getFileNumber();
        io.writeUnsignedInt(16, ((Number)fileNumber).intValue());
        int recordNumber = _value.getRecordNumber();
        io.writeUnsignedInt(16, ((Number)recordNumber).intValue());
        int recordLength = StaticHelper.COUNT((Object)_value.getRecordData()) * 2 / 2;
        io.writeUnsignedInt(16, ((Number)recordLength).intValue());
        if (_value.getRecordData() != null) {
            int itemCount = _value.getRecordData().length;
            int curItem = 0;
            for (int element : _value.getRecordData()) {
                io.writeUnsignedInt(16, ((Number)element).intValue());
                ++curItem;
            }
        }
    }
}

