/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite.io;

import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadWriteMultipleHoldingRegistersRequest;
import org.apache.plc4x.java.modbus.readwrite.io.ModbusPDUIO;
import org.apache.plc4x.java.spi.generation.MessageIO;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusPDUReadWriteMultipleHoldingRegistersRequestIO
implements MessageIO<ModbusPDUReadWriteMultipleHoldingRegistersRequest, ModbusPDUReadWriteMultipleHoldingRegistersRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModbusPDUReadWriteMultipleHoldingRegistersRequestIO.class);

    public ModbusPDUReadWriteMultipleHoldingRegistersRequest parse(ReadBuffer io, Object ... args) throws ParseException {
        return (ModbusPDUReadWriteMultipleHoldingRegistersRequest)new ModbusPDUIO().parse(io, args);
    }

    public void serialize(WriteBuffer io, ModbusPDUReadWriteMultipleHoldingRegistersRequest value, Object ... args) throws ParseException {
        new ModbusPDUIO().serialize(io, value, args);
    }

    public static ModbusPDUReadWriteMultipleHoldingRegistersRequestBuilder staticParse(ReadBuffer io, Boolean response) throws ParseException {
        int startPos = io.getPos();
        int readStartingAddress = io.readUnsignedInt(16);
        int readQuantity = io.readUnsignedInt(16);
        int writeStartingAddress = io.readUnsignedInt(16);
        int writeQuantity = io.readUnsignedInt(16);
        int byteCount = io.readUnsignedShort(8);
        if (byteCount > Integer.MAX_VALUE) {
            throw new ParseException("Array count of " + byteCount + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
        }
        int itemCount = byteCount;
        byte[] value = new byte[itemCount];
        for (int curItem = 0; curItem < itemCount; ++curItem) {
            value[curItem] = io.readByte(8);
        }
        return new ModbusPDUReadWriteMultipleHoldingRegistersRequestBuilder(readStartingAddress, readQuantity, writeStartingAddress, writeQuantity, value);
    }

    public static void staticSerialize(WriteBuffer io, ModbusPDUReadWriteMultipleHoldingRegistersRequest _value) throws ParseException {
        int startPos = io.getPos();
        int readStartingAddress = _value.getReadStartingAddress();
        io.writeUnsignedInt(16, ((Number)readStartingAddress).intValue());
        int readQuantity = _value.getReadQuantity();
        io.writeUnsignedInt(16, ((Number)readQuantity).intValue());
        int writeStartingAddress = _value.getWriteStartingAddress();
        io.writeUnsignedInt(16, ((Number)writeStartingAddress).intValue());
        int writeQuantity = _value.getWriteQuantity();
        io.writeUnsignedInt(16, ((Number)writeQuantity).intValue());
        short byteCount = (short)StaticHelper.COUNT((Object)_value.getValue());
        io.writeUnsignedShort(8, ((Number)byteCount).shortValue());
        if (_value.getValue() != null) {
            int itemCount = _value.getValue().length;
            int curItem = 0;
            for (byte element : _value.getValue()) {
                io.writeByte(8, ((Number)element).byteValue());
                ++curItem;
            }
        }
    }

    public static class ModbusPDUReadWriteMultipleHoldingRegistersRequestBuilder
    implements ModbusPDUIO.ModbusPDUBuilder {
        private final int readStartingAddress;
        private final int readQuantity;
        private final int writeStartingAddress;
        private final int writeQuantity;
        private final byte[] value;

        public ModbusPDUReadWriteMultipleHoldingRegistersRequestBuilder(int readStartingAddress, int readQuantity, int writeStartingAddress, int writeQuantity, byte[] value) {
            this.readStartingAddress = readStartingAddress;
            this.readQuantity = readQuantity;
            this.writeStartingAddress = writeStartingAddress;
            this.writeQuantity = writeQuantity;
            this.value = value;
        }

        @Override
        public ModbusPDUReadWriteMultipleHoldingRegistersRequest build() {
            return new ModbusPDUReadWriteMultipleHoldingRegistersRequest(this.readStartingAddress, this.readQuantity, this.writeStartingAddress, this.writeQuantity, this.value);
        }
    }
}

