/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite.io;

import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadFifoQueueResponse;
import org.apache.plc4x.java.modbus.readwrite.io.ModbusPDUIO;
import org.apache.plc4x.java.spi.generation.MessageIO;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusPDUReadFifoQueueResponseIO
implements MessageIO<ModbusPDUReadFifoQueueResponse, ModbusPDUReadFifoQueueResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModbusPDUReadFifoQueueResponseIO.class);

    public ModbusPDUReadFifoQueueResponse parse(ReadBuffer io, Object ... args) throws ParseException {
        return (ModbusPDUReadFifoQueueResponse)new ModbusPDUIO().parse(io, args);
    }

    public void serialize(WriteBuffer io, ModbusPDUReadFifoQueueResponse value, Object ... args) throws ParseException {
        new ModbusPDUIO().serialize(io, value, args);
    }

    public static ModbusPDUReadFifoQueueResponseBuilder staticParse(ReadBuffer io, Boolean response) throws ParseException {
        int startPos = io.getPos();
        int byteCount = io.readUnsignedInt(16);
        int fifoCount = io.readUnsignedInt(16);
        if (fifoCount > Integer.MAX_VALUE) {
            throw new ParseException("Array count of " + fifoCount + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
        }
        int itemCount = fifoCount;
        int[] fifoValue = new int[itemCount];
        for (int curItem = 0; curItem < itemCount; ++curItem) {
            fifoValue[curItem] = io.readUnsignedInt(16);
        }
        return new ModbusPDUReadFifoQueueResponseBuilder(fifoValue);
    }

    public static void staticSerialize(WriteBuffer io, ModbusPDUReadFifoQueueResponse _value) throws ParseException {
        int startPos = io.getPos();
        int byteCount = StaticHelper.COUNT((Object)_value.getFifoValue()) * 2 + 2;
        io.writeUnsignedInt(16, ((Number)byteCount).intValue());
        int fifoCount = StaticHelper.COUNT((Object)_value.getFifoValue()) * 2 / 2;
        io.writeUnsignedInt(16, ((Number)fifoCount).intValue());
        if (_value.getFifoValue() != null) {
            int itemCount = _value.getFifoValue().length;
            int curItem = 0;
            for (int element : _value.getFifoValue()) {
                io.writeUnsignedInt(16, ((Number)element).intValue());
                ++curItem;
            }
        }
    }

    public static class ModbusPDUReadFifoQueueResponseBuilder
    implements ModbusPDUIO.ModbusPDUBuilder {
        private final int[] fifoValue;

        public ModbusPDUReadFifoQueueResponseBuilder(int[] fifoValue) {
            this.fifoValue = fifoValue;
        }

        @Override
        public ModbusPDUReadFifoQueueResponse build() {
            return new ModbusPDUReadFifoQueueResponse(this.fifoValue);
        }
    }
}

