/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite.io;

import org.apache.plc4x.java.modbus.readwrite.ModbusPDUGetComEventLogResponse;
import org.apache.plc4x.java.modbus.readwrite.io.ModbusPDUIO;
import org.apache.plc4x.java.spi.generation.MessageIO;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusPDUGetComEventLogResponseIO
implements MessageIO<ModbusPDUGetComEventLogResponse, ModbusPDUGetComEventLogResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModbusPDUGetComEventLogResponseIO.class);

    public ModbusPDUGetComEventLogResponse parse(ReadBuffer io, Object ... args) throws ParseException {
        return (ModbusPDUGetComEventLogResponse)new ModbusPDUIO().parse(io, args);
    }

    public void serialize(WriteBuffer io, ModbusPDUGetComEventLogResponse value, Object ... args) throws ParseException {
        new ModbusPDUIO().serialize(io, value, args);
    }

    public static ModbusPDUGetComEventLogResponseBuilder staticParse(ReadBuffer io, Boolean response) throws ParseException {
        int startPos = io.getPos();
        short byteCount = io.readUnsignedShort(8);
        int status = io.readUnsignedInt(16);
        int eventCount = io.readUnsignedInt(16);
        int messageCount = io.readUnsignedInt(16);
        if (byteCount - 6 > Integer.MAX_VALUE) {
            throw new ParseException("Array count of " + (byteCount - 6) + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
        }
        int itemCount = byteCount - 6;
        byte[] events = new byte[itemCount];
        for (int curItem = 0; curItem < itemCount; ++curItem) {
            events[curItem] = io.readByte(8);
        }
        return new ModbusPDUGetComEventLogResponseBuilder(status, eventCount, messageCount, events);
    }

    public static void staticSerialize(WriteBuffer io, ModbusPDUGetComEventLogResponse _value) throws ParseException {
        int startPos = io.getPos();
        short byteCount = (short)(StaticHelper.COUNT((Object)_value.getEvents()) + 6);
        io.writeUnsignedShort(8, ((Number)byteCount).shortValue());
        int status = _value.getStatus();
        io.writeUnsignedInt(16, ((Number)status).intValue());
        int eventCount = _value.getEventCount();
        io.writeUnsignedInt(16, ((Number)eventCount).intValue());
        int messageCount = _value.getMessageCount();
        io.writeUnsignedInt(16, ((Number)messageCount).intValue());
        if (_value.getEvents() != null) {
            int itemCount = _value.getEvents().length;
            int curItem = 0;
            for (byte element : _value.getEvents()) {
                io.writeByte(8, ((Number)element).byteValue());
                ++curItem;
            }
        }
    }

    public static class ModbusPDUGetComEventLogResponseBuilder
    implements ModbusPDUIO.ModbusPDUBuilder {
        private final int status;
        private final int eventCount;
        private final int messageCount;
        private final byte[] events;

        public ModbusPDUGetComEventLogResponseBuilder(int status, int eventCount, int messageCount, byte[] events) {
            this.status = status;
            this.eventCount = eventCount;
            this.messageCount = messageCount;
            this.events = events;
        }

        @Override
        public ModbusPDUGetComEventLogResponse build() {
            return new ModbusPDUGetComEventLogResponse(this.status, this.eventCount, this.messageCount, this.events);
        }
    }
}

