/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite.io;

import java.util.Arrays;
import org.apache.plc4x.java.api.value.PlcBoolean;
import org.apache.plc4x.java.api.value.PlcInteger;
import org.apache.plc4x.java.api.value.PlcList;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItemIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataItemIO.class);

    public static PlcValue staticParse(ReadBuffer io, Short dataType, Short numberOfValues) throws ParseException {
        if (EvaluationHelper.equals((Object)dataType, (Object)1) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            short reserved = io.readUnsignedShort(7);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = io.readBit();
            return new PlcBoolean(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)1)) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues.shortValue();
            Boolean[] value = new Boolean[itemCount];
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value[curItem] = io.readBit();
            }
            return new PlcList(Arrays.asList(value));
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)2) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Short value = io.readShort(16);
            return new PlcInteger((int)value.shortValue());
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)2)) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues.shortValue();
            Short[] value = new Short[itemCount];
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value[curItem] = io.readShort(16);
            }
            return new PlcList(Arrays.asList(value));
        }
        return null;
    }

    public static WriteBuffer staticSerialize(PlcValue _value, Short dataType, Short numberOfValues) throws ParseException {
        if (EvaluationHelper.equals((Object)dataType, (Object)1) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            WriteBuffer io = new WriteBuffer(1);
            io.writeUnsignedShort(7, ((Number)0).shortValue());
            boolean value = _value.getBoolean();
            io.writeBit(value);
            return io;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)1)) {
            WriteBuffer io = new WriteBuffer(numberOfValues * 1 + 0);
            return io;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)2) && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            WriteBuffer io = new WriteBuffer(2);
            short value = (short)_value.getInteger();
            io.writeShort(16, ((Number)value).shortValue());
            return io;
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)2)) {
            WriteBuffer io = new WriteBuffer(numberOfValues * 16 + 0);
            return io;
        }
        return null;
    }
}

