/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.plc4x.java.api.value.PlcStruct;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.api.value.PlcValues;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.modbus.readwrite.io.ModbusTcpADUIO;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class ModbusTcpADU
implements Message {
    public static final int PROTOCOLIDENTIFIER = 0;
    private final int transactionIdentifier;
    private final short unitIdentifier;
    private final ModbusPDU pdu;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public ModbusTcpADU(@JsonProperty(value="transactionIdentifier") int transactionIdentifier, @JsonProperty(value="unitIdentifier") short unitIdentifier, @JsonProperty(value="pdu") ModbusPDU pdu) {
        this.transactionIdentifier = transactionIdentifier;
        this.unitIdentifier = unitIdentifier;
        this.pdu = pdu;
    }

    public int getTransactionIdentifier() {
        return this.transactionIdentifier;
    }

    public short getUnitIdentifier() {
        return this.unitIdentifier;
    }

    public ModbusPDU getPdu() {
        return this.pdu;
    }

    @JsonIgnore
    public int getLengthInBytes() {
        return this.getLengthInBits() / 8;
    }

    @JsonIgnore
    public int getLengthInBits() {
        int lengthInBits = 0;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 8;
        return lengthInBits += this.pdu.getLengthInBits();
    }

    public PlcValue toPlcValue() {
        TreeMap<String, PlcValue> fieldValues = new TreeMap<String, PlcValue>();
        fieldValues.put("transactionIdentifier", PlcValues.of((int)this.transactionIdentifier));
        fieldValues.put("unitIdentifier", PlcValues.of((short)this.unitIdentifier));
        fieldValues.put("pdu", this.pdu.toPlcValue());
        return new PlcStruct(fieldValues);
    }

    @JsonIgnore
    public MessageIO<ModbusTcpADU, ModbusTcpADU> getMessageIO() {
        return new ModbusTcpADUIO();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusTcpADU)) {
            return false;
        }
        ModbusTcpADU that = (ModbusTcpADU)o;
        return this.getTransactionIdentifier() == that.getTransactionIdentifier() && this.getUnitIdentifier() == that.getUnitIdentifier() && this.getPdu() == that.getPdu();
    }

    public int hashCode() {
        return Objects.hash(this.getTransactionIdentifier(), this.getUnitIdentifier(), this.getPdu());
    }

    public String toString() {
        return this.toString(ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public String toString(ToStringStyle style) {
        return new ToStringBuilder((Object)this, style).append("transactionIdentifier", this.getTransactionIdentifier()).append("unitIdentifier", this.getUnitIdentifier()).append("pdu", (Object)this.getPdu()).toString();
    }
}

