/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.plc4x.java.api.value.PlcStruct;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.api.value.PlcValues;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.modbus.readwrite.io.ModbusSerialADUIO;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class ModbusSerialADU
implements Message {
    private final int transactionId;
    private final int length;
    private final short address;
    private final ModbusPDU pdu;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public ModbusSerialADU(@JsonProperty(value="transactionId") int transactionId, @JsonProperty(value="length") int length, @JsonProperty(value="address") short address, @JsonProperty(value="pdu") ModbusPDU pdu) {
        this.transactionId = transactionId;
        this.length = length;
        this.address = address;
        this.pdu = pdu;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public int getLength() {
        return this.length;
    }

    public short getAddress() {
        return this.address;
    }

    public ModbusPDU getPdu() {
        return this.pdu;
    }

    @JsonIgnore
    public int getLengthInBytes() {
        return this.getLengthInBits() / 8;
    }

    @JsonIgnore
    public int getLengthInBits() {
        int lengthInBits = 0;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 8;
        return lengthInBits += this.pdu.getLengthInBits();
    }

    public PlcValue toPlcValue() {
        TreeMap<String, PlcValue> fieldValues = new TreeMap<String, PlcValue>();
        fieldValues.put("transactionId", PlcValues.of((int)this.transactionId));
        fieldValues.put("length", PlcValues.of((int)this.length));
        fieldValues.put("address", PlcValues.of((short)this.address));
        fieldValues.put("pdu", this.pdu.toPlcValue());
        return new PlcStruct(fieldValues);
    }

    @JsonIgnore
    public MessageIO<ModbusSerialADU, ModbusSerialADU> getMessageIO() {
        return new ModbusSerialADUIO();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusSerialADU)) {
            return false;
        }
        ModbusSerialADU that = (ModbusSerialADU)o;
        return this.getTransactionId() == that.getTransactionId() && this.getLength() == that.getLength() && this.getAddress() == that.getAddress() && this.getPdu() == that.getPdu();
    }

    public int hashCode() {
        return Objects.hash(this.getTransactionId(), this.getLength(), this.getAddress(), this.getPdu());
    }

    public String toString() {
        return this.toString(ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public String toString(ToStringStyle style) {
        return new ToStringBuilder((Object)this, style).append("transactionId", this.getTransactionId()).append("length", this.getLength()).append("address", this.getAddress()).append("pdu", (Object)this.getPdu()).toString();
    }
}

