/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.plc4x.java.api.value.PlcList;
import org.apache.plc4x.java.api.value.PlcStruct;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteFileRecordRequestItem;
import org.apache.plc4x.java.modbus.readwrite.io.ModbusPDUIO;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class ModbusPDUWriteFileRecordRequest
extends ModbusPDU
implements Message {
    private final ModbusPDUWriteFileRecordRequestItem[] items;

    @Override
    @JsonIgnore
    public Boolean getResponse() {
        return false;
    }

    @Override
    @JsonIgnore
    public Short getFunction() {
        return (short)21;
    }

    @Override
    @JsonIgnore
    public Boolean getError() {
        return false;
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public ModbusPDUWriteFileRecordRequest(@JsonProperty(value="items") ModbusPDUWriteFileRecordRequestItem[] items) {
        this.items = items;
    }

    public ModbusPDUWriteFileRecordRequestItem[] getItems() {
        return this.items;
    }

    @Override
    @JsonIgnore
    public int getLengthInBytes() {
        return this.getLengthInBits() / 8;
    }

    @Override
    @JsonIgnore
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        lengthInBits += 8;
        if (this.items != null) {
            for (ModbusPDUWriteFileRecordRequestItem element : this.items) {
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    @Override
    public PlcValue toPlcValue() {
        TreeMap<String, PlcList> fieldValues = new TreeMap<String, PlcList>();
        ArrayList<PlcValue> plcValues = new ArrayList<PlcValue>(this.items.length);
        for (ModbusPDUWriteFileRecordRequestItem item : this.items) {
            plcValues.add(item.toPlcValue());
        }
        fieldValues.put("items", new PlcList(plcValues));
        return new PlcStruct(fieldValues);
    }

    @Override
    @JsonIgnore
    public MessageIO<ModbusPDU, ModbusPDU> getMessageIO() {
        return new ModbusPDUIO();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusPDUWriteFileRecordRequest)) {
            return false;
        }
        ModbusPDUWriteFileRecordRequest that = (ModbusPDUWriteFileRecordRequest)o;
        return this.getItems() == that.getItems() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getItems());
    }

    @Override
    public String toString() {
        return this.toString(ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public String toString(ToStringStyle style) {
        return new ToStringBuilder((Object)this, style).appendSuper(super.toString(style)).append("items", (Object[])this.getItems()).toString();
    }
}

