/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.plc4x.java.api.value.PlcList;
import org.apache.plc4x.java.api.value.PlcStruct;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.api.value.PlcValues;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.modbus.readwrite.io.ModbusPDUIO;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class ModbusPDUReadWriteMultipleHoldingRegistersRequest
extends ModbusPDU
implements Message {
    private final int readStartingAddress;
    private final int readQuantity;
    private final int writeStartingAddress;
    private final int writeQuantity;
    private final byte[] value;

    @Override
    @JsonIgnore
    public Boolean getResponse() {
        return false;
    }

    @Override
    @JsonIgnore
    public Short getFunction() {
        return (short)23;
    }

    @Override
    @JsonIgnore
    public Boolean getError() {
        return false;
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public ModbusPDUReadWriteMultipleHoldingRegistersRequest(@JsonProperty(value="readStartingAddress") int readStartingAddress, @JsonProperty(value="readQuantity") int readQuantity, @JsonProperty(value="writeStartingAddress") int writeStartingAddress, @JsonProperty(value="writeQuantity") int writeQuantity, @JsonProperty(value="value") byte[] value) {
        this.readStartingAddress = readStartingAddress;
        this.readQuantity = readQuantity;
        this.writeStartingAddress = writeStartingAddress;
        this.writeQuantity = writeQuantity;
        this.value = value;
    }

    public int getReadStartingAddress() {
        return this.readStartingAddress;
    }

    public int getReadQuantity() {
        return this.readQuantity;
    }

    public int getWriteStartingAddress() {
        return this.writeStartingAddress;
    }

    public int getWriteQuantity() {
        return this.writeQuantity;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    @JsonIgnore
    public int getLengthInBytes() {
        return this.getLengthInBits() / 8;
    }

    @Override
    @JsonIgnore
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 8;
        return lengthInBits += 8 * this.value.length;
    }

    @Override
    public PlcValue toPlcValue() {
        TreeMap<String, Object> fieldValues = new TreeMap<String, Object>();
        fieldValues.put("readStartingAddress", PlcValues.of((int)this.readStartingAddress));
        fieldValues.put("readQuantity", PlcValues.of((int)this.readQuantity));
        fieldValues.put("writeStartingAddress", PlcValues.of((int)this.writeStartingAddress));
        fieldValues.put("writeQuantity", PlcValues.of((int)this.writeQuantity));
        ArrayList<PlcValue> plcValues = new ArrayList<PlcValue>(this.value.length);
        for (byte item : this.value) {
            plcValues.add(PlcValues.of((byte)item));
        }
        fieldValues.put("value", new PlcList(plcValues));
        return new PlcStruct(fieldValues);
    }

    @Override
    @JsonIgnore
    public MessageIO<ModbusPDU, ModbusPDU> getMessageIO() {
        return new ModbusPDUIO();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusPDUReadWriteMultipleHoldingRegistersRequest)) {
            return false;
        }
        ModbusPDUReadWriteMultipleHoldingRegistersRequest that = (ModbusPDUReadWriteMultipleHoldingRegistersRequest)o;
        return this.getReadStartingAddress() == that.getReadStartingAddress() && this.getReadQuantity() == that.getReadQuantity() && this.getWriteStartingAddress() == that.getWriteStartingAddress() && this.getWriteQuantity() == that.getWriteQuantity() && this.getValue() == that.getValue() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getReadStartingAddress(), this.getReadQuantity(), this.getWriteStartingAddress(), this.getWriteQuantity(), this.getValue());
    }

    @Override
    public String toString() {
        return this.toString(ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public String toString(ToStringStyle style) {
        return new ToStringBuilder((Object)this, style).appendSuper(super.toString(style)).append("readStartingAddress", this.getReadStartingAddress()).append("readQuantity", this.getReadQuantity()).append("writeStartingAddress", this.getWriteStartingAddress()).append("writeQuantity", this.getWriteQuantity()).append("value", this.getValue()).toString();
    }
}

