/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.plc4x.java.api.value.PlcList;
import org.apache.plc4x.java.api.value.PlcStruct;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.api.value.PlcValues;
import org.apache.plc4x.java.modbus.readwrite.io.ModbusPDUReadFileRecordResponseItemIO;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class ModbusPDUReadFileRecordResponseItem
implements Message {
    private final short referenceType;
    private final int[] data;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public ModbusPDUReadFileRecordResponseItem(@JsonProperty(value="referenceType") short referenceType, @JsonProperty(value="data") int[] data) {
        this.referenceType = referenceType;
        this.data = data;
    }

    public short getReferenceType() {
        return this.referenceType;
    }

    public int[] getData() {
        return this.data;
    }

    @JsonIgnore
    public int getLengthInBytes() {
        return this.getLengthInBits() / 8;
    }

    @JsonIgnore
    public int getLengthInBits() {
        int lengthInBits = 0;
        lengthInBits += 8;
        lengthInBits += 8;
        return lengthInBits += 16 * this.data.length;
    }

    public PlcValue toPlcValue() {
        TreeMap<String, Object> fieldValues = new TreeMap<String, Object>();
        fieldValues.put("referenceType", PlcValues.of((short)this.referenceType));
        ArrayList<PlcValue> plcValues = new ArrayList<PlcValue>(this.data.length);
        for (int item : this.data) {
            plcValues.add(PlcValues.of((int)item));
        }
        fieldValues.put("data", new PlcList(plcValues));
        return new PlcStruct(fieldValues);
    }

    @JsonIgnore
    public MessageIO<ModbusPDUReadFileRecordResponseItem, ModbusPDUReadFileRecordResponseItem> getMessageIO() {
        return new ModbusPDUReadFileRecordResponseItemIO();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusPDUReadFileRecordResponseItem)) {
            return false;
        }
        ModbusPDUReadFileRecordResponseItem that = (ModbusPDUReadFileRecordResponseItem)o;
        return this.getReferenceType() == that.getReferenceType() && this.getData() == that.getData();
    }

    public int hashCode() {
        return Objects.hash(this.getReferenceType(), this.getData());
    }

    public String toString() {
        return this.toString(ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public String toString(ToStringStyle style) {
        return new ToStringBuilder((Object)this, style).append("referenceType", this.getReferenceType()).append("data", this.getData()).toString();
    }
}

