/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.plc4x.java.api.value.PlcStruct;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.api.value.PlcValues;
import org.apache.plc4x.java.modbus.readwrite.io.ModbusPDUReadFileRecordRequestItemIO;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class ModbusPDUReadFileRecordRequestItem
implements Message {
    private final short referenceType;
    private final int fileNumber;
    private final int recordNumber;
    private final int recordLength;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public ModbusPDUReadFileRecordRequestItem(@JsonProperty(value="referenceType") short referenceType, @JsonProperty(value="fileNumber") int fileNumber, @JsonProperty(value="recordNumber") int recordNumber, @JsonProperty(value="recordLength") int recordLength) {
        this.referenceType = referenceType;
        this.fileNumber = fileNumber;
        this.recordNumber = recordNumber;
        this.recordLength = recordLength;
    }

    public short getReferenceType() {
        return this.referenceType;
    }

    public int getFileNumber() {
        return this.fileNumber;
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    @JsonIgnore
    public int getLengthInBytes() {
        return this.getLengthInBits() / 8;
    }

    @JsonIgnore
    public int getLengthInBits() {
        int lengthInBits = 0;
        lengthInBits += 8;
        lengthInBits += 16;
        lengthInBits += 16;
        return lengthInBits += 16;
    }

    public PlcValue toPlcValue() {
        TreeMap<String, PlcValue> fieldValues = new TreeMap<String, PlcValue>();
        fieldValues.put("referenceType", PlcValues.of((short)this.referenceType));
        fieldValues.put("fileNumber", PlcValues.of((int)this.fileNumber));
        fieldValues.put("recordNumber", PlcValues.of((int)this.recordNumber));
        fieldValues.put("recordLength", PlcValues.of((int)this.recordLength));
        return new PlcStruct(fieldValues);
    }

    @JsonIgnore
    public MessageIO<ModbusPDUReadFileRecordRequestItem, ModbusPDUReadFileRecordRequestItem> getMessageIO() {
        return new ModbusPDUReadFileRecordRequestItemIO();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusPDUReadFileRecordRequestItem)) {
            return false;
        }
        ModbusPDUReadFileRecordRequestItem that = (ModbusPDUReadFileRecordRequestItem)o;
        return this.getReferenceType() == that.getReferenceType() && this.getFileNumber() == that.getFileNumber() && this.getRecordNumber() == that.getRecordNumber() && this.getRecordLength() == that.getRecordLength();
    }

    public int hashCode() {
        return Objects.hash(this.getReferenceType(), this.getFileNumber(), this.getRecordNumber(), this.getRecordLength());
    }

    public String toString() {
        return this.toString(ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public String toString(ToStringStyle style) {
        return new ToStringBuilder((Object)this, style).append("referenceType", this.getReferenceType()).append("fileNumber", this.getFileNumber()).append("recordNumber", this.getRecordNumber()).append("recordLength", this.getRecordLength()).toString();
    }
}

