/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.plc4x.java.api.value.PlcList;
import org.apache.plc4x.java.api.value.PlcStruct;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.api.value.PlcValues;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.modbus.readwrite.io.ModbusPDUIO;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class ModbusPDUReadFifoQueueResponse
extends ModbusPDU
implements Message {
    private final int[] fifoValue;

    @Override
    @JsonIgnore
    public Boolean getResponse() {
        return true;
    }

    @Override
    @JsonIgnore
    public Short getFunction() {
        return (short)24;
    }

    @Override
    @JsonIgnore
    public Boolean getError() {
        return false;
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public ModbusPDUReadFifoQueueResponse(@JsonProperty(value="fifoValue") int[] fifoValue) {
        this.fifoValue = fifoValue;
    }

    public int[] getFifoValue() {
        return this.fifoValue;
    }

    @Override
    @JsonIgnore
    public int getLengthInBytes() {
        return this.getLengthInBits() / 8;
    }

    @Override
    @JsonIgnore
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        lengthInBits += 16;
        lengthInBits += 16;
        return lengthInBits += 16 * this.fifoValue.length;
    }

    @Override
    public PlcValue toPlcValue() {
        TreeMap<String, PlcList> fieldValues = new TreeMap<String, PlcList>();
        ArrayList<PlcValue> plcValues = new ArrayList<PlcValue>(this.fifoValue.length);
        for (int item : this.fifoValue) {
            plcValues.add(PlcValues.of((int)item));
        }
        fieldValues.put("fifoValue", new PlcList(plcValues));
        return new PlcStruct(fieldValues);
    }

    @Override
    @JsonIgnore
    public MessageIO<ModbusPDU, ModbusPDU> getMessageIO() {
        return new ModbusPDUIO();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusPDUReadFifoQueueResponse)) {
            return false;
        }
        ModbusPDUReadFifoQueueResponse that = (ModbusPDUReadFifoQueueResponse)o;
        return this.getFifoValue() == that.getFifoValue() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getFifoValue());
    }

    @Override
    public String toString() {
        return this.toString(ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public String toString(ToStringStyle style) {
        return new ToStringBuilder((Object)this, style).appendSuper(super.toString(style)).append("fifoValue", this.getFifoValue()).toString();
    }
}

