/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.plc4x.java.api.value.PlcList;
import org.apache.plc4x.java.api.value.PlcStruct;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.api.value.PlcValues;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.modbus.readwrite.io.ModbusPDUIO;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class ModbusPDUReadDiscreteInputsResponse
extends ModbusPDU
implements Message {
    private final byte[] value;

    @Override
    @JsonIgnore
    public Boolean getResponse() {
        return true;
    }

    @Override
    @JsonIgnore
    public Short getFunction() {
        return (short)2;
    }

    @Override
    @JsonIgnore
    public Boolean getError() {
        return false;
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public ModbusPDUReadDiscreteInputsResponse(@JsonProperty(value="value") byte[] value) {
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    @JsonIgnore
    public int getLengthInBytes() {
        return this.getLengthInBits() / 8;
    }

    @Override
    @JsonIgnore
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        lengthInBits += 8;
        return lengthInBits += 8 * this.value.length;
    }

    @Override
    public PlcValue toPlcValue() {
        TreeMap<String, PlcList> fieldValues = new TreeMap<String, PlcList>();
        ArrayList<PlcValue> plcValues = new ArrayList<PlcValue>(this.value.length);
        for (byte item : this.value) {
            plcValues.add(PlcValues.of((byte)item));
        }
        fieldValues.put("value", new PlcList(plcValues));
        return new PlcStruct(fieldValues);
    }

    @Override
    @JsonIgnore
    public MessageIO<ModbusPDU, ModbusPDU> getMessageIO() {
        return new ModbusPDUIO();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusPDUReadDiscreteInputsResponse)) {
            return false;
        }
        ModbusPDUReadDiscreteInputsResponse that = (ModbusPDUReadDiscreteInputsResponse)o;
        return this.getValue() == that.getValue() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getValue());
    }

    @Override
    public String toString() {
        return this.toString(ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public String toString(ToStringStyle style) {
        return new ToStringBuilder((Object)this, style).appendSuper(super.toString(style)).append("value", this.getValue()).toString();
    }
}

