/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.plc4x.java.api.value.PlcList;
import org.apache.plc4x.java.api.value.PlcStruct;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.api.value.PlcValues;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.modbus.readwrite.io.ModbusPDUIO;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class ModbusPDUGetComEventLogResponse
extends ModbusPDU
implements Message {
    private final int status;
    private final int eventCount;
    private final int messageCount;
    private final byte[] events;

    @Override
    @JsonIgnore
    public Boolean getResponse() {
        return true;
    }

    @Override
    @JsonIgnore
    public Short getFunction() {
        return (short)12;
    }

    @Override
    @JsonIgnore
    public Boolean getError() {
        return false;
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public ModbusPDUGetComEventLogResponse(@JsonProperty(value="status") int status, @JsonProperty(value="eventCount") int eventCount, @JsonProperty(value="messageCount") int messageCount, @JsonProperty(value="events") byte[] events) {
        this.status = status;
        this.eventCount = eventCount;
        this.messageCount = messageCount;
        this.events = events;
    }

    public int getStatus() {
        return this.status;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public byte[] getEvents() {
        return this.events;
    }

    @Override
    @JsonIgnore
    public int getLengthInBytes() {
        return this.getLengthInBits() / 8;
    }

    @Override
    @JsonIgnore
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        lengthInBits += 8;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 16;
        return lengthInBits += 8 * this.events.length;
    }

    @Override
    public PlcValue toPlcValue() {
        TreeMap<String, Object> fieldValues = new TreeMap<String, Object>();
        fieldValues.put("status", PlcValues.of((int)this.status));
        fieldValues.put("eventCount", PlcValues.of((int)this.eventCount));
        fieldValues.put("messageCount", PlcValues.of((int)this.messageCount));
        ArrayList<PlcValue> plcValues = new ArrayList<PlcValue>(this.events.length);
        for (byte item : this.events) {
            plcValues.add(PlcValues.of((byte)item));
        }
        fieldValues.put("events", new PlcList(plcValues));
        return new PlcStruct(fieldValues);
    }

    @Override
    @JsonIgnore
    public MessageIO<ModbusPDU, ModbusPDU> getMessageIO() {
        return new ModbusPDUIO();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusPDUGetComEventLogResponse)) {
            return false;
        }
        ModbusPDUGetComEventLogResponse that = (ModbusPDUGetComEventLogResponse)o;
        return this.getStatus() == that.getStatus() && this.getEventCount() == that.getEventCount() && this.getMessageCount() == that.getMessageCount() && this.getEvents() == that.getEvents() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getStatus(), this.getEventCount(), this.getMessageCount(), this.getEvents());
    }

    @Override
    public String toString() {
        return this.toString(ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public String toString(ToStringStyle style) {
        return new ToStringBuilder((Object)this, style).appendSuper(super.toString(style)).append("status", this.getStatus()).append("eventCount", this.getEventCount()).append("messageCount", this.getMessageCount()).append("events", this.getEvents()).toString();
    }
}

