/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.protocol;

import java.time.Duration;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcBoolean;
import org.apache.plc4x.java.api.value.PlcList;
import org.apache.plc4x.java.api.value.PlcShort;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.modbus.config.ModbusConfiguration;
import org.apache.plc4x.java.modbus.field.ModbusFieldCoil;
import org.apache.plc4x.java.modbus.field.ModbusFieldDiscreteInput;
import org.apache.plc4x.java.modbus.field.ModbusFieldHoldingRegister;
import org.apache.plc4x.java.modbus.field.ModbusFieldInputRegister;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUError;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadCoilsRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadCoilsResponse;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadDiscreteInputsRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadDiscreteInputsResponse;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadHoldingRegistersRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadHoldingRegistersResponse;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadInputRegistersRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadInputRegistersResponse;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteMultipleCoilsRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteMultipleHoldingRegistersRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusTcpADU;
import org.apache.plc4x.java.modbus.readwrite.io.DataItemIO;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.InternalPlcReadRequest;
import org.apache.plc4x.java.spi.messages.InternalPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;

public class ModbusProtocolLogic
extends Plc4xProtocolBase<ModbusTcpADU>
implements HasConfiguration<ModbusConfiguration> {
    private Duration requestTimeout;
    private short unitIdentifier;
    private RequestTransactionManager tm;
    private AtomicInteger transactionIdentifierGenerator = new AtomicInteger(10);

    public void setConfiguration(ModbusConfiguration configuration) {
        this.requestTimeout = Duration.ofMillis(configuration.getRequestTimeout());
        this.unitIdentifier = (short)configuration.getUnitIdentifier();
        this.tm = new RequestTransactionManager(1);
        this.transactionIdentifierGenerator = new AtomicInteger(10);
    }

    public void close(ConversationContext<ModbusTcpADU> context) {
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        CompletableFuture<PlcReadResponse> future = new CompletableFuture<PlcReadResponse>();
        DefaultPlcReadRequest request = (DefaultPlcReadRequest)readRequest;
        if (request.getFieldNames().size() == 1) {
            String fieldName = (String)request.getFieldNames().iterator().next();
            PlcField field = request.getField(fieldName);
            ModbusPDU requestPdu = this.getReadRequestPdu(field);
            int transactionIdentifier = this.transactionIdentifierGenerator.getAndIncrement();
            ModbusTcpADU modbusTcpADU = new ModbusTcpADU(transactionIdentifier, this.unitIdentifier, requestPdu);
            RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
            transaction.submit(() -> this.context.sendRequest((Object)modbusTcpADU).expectResponse(ModbusTcpADU.class, this.requestTimeout).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).check(p -> p.getTransactionIdentifier() == transactionIdentifier).unwrap(ModbusTcpADU::getPdu).handle(responsePdu -> {
                PlcResponseCode responseCode;
                PlcValue plcValue = null;
                if (responsePdu instanceof ModbusPDUError) {
                    ModbusPDUError errorResponse = (ModbusPDUError)responsePdu;
                    switch (errorResponse.getExceptionCode()) {
                        case 1: {
                            responseCode = PlcResponseCode.UNSUPPORTED;
                            break;
                        }
                        case 2: {
                            responseCode = PlcResponseCode.INVALID_ADDRESS;
                            break;
                        }
                        case 3: {
                            responseCode = PlcResponseCode.INVALID_DATA;
                            break;
                        }
                        case 4: {
                            responseCode = PlcResponseCode.REMOTE_ERROR;
                            break;
                        }
                        case 6: {
                            responseCode = PlcResponseCode.REMOTE_BUSY;
                            break;
                        }
                        default: {
                            responseCode = PlcResponseCode.INTERNAL_ERROR;
                            break;
                        }
                    }
                } else {
                    try {
                        plcValue = this.toPlcValue(requestPdu, (ModbusPDU)responsePdu);
                        responseCode = PlcResponseCode.OK;
                    }
                    catch (ParseException e) {
                        responseCode = PlcResponseCode.INTERNAL_ERROR;
                    }
                }
                DefaultPlcReadResponse response = new DefaultPlcReadResponse((InternalPlcReadRequest)request, Collections.singletonMap(fieldName, new ResponseItem(responseCode, (Object)plcValue)));
                future.complete((PlcReadResponse)response);
                transaction.endRequest();
            }));
        } else {
            future.completeExceptionally((Throwable)new PlcRuntimeException("Modbus only supports single filed requests"));
        }
        return future;
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        CompletableFuture<PlcWriteResponse> future = new CompletableFuture<PlcWriteResponse>();
        DefaultPlcWriteRequest request = (DefaultPlcWriteRequest)writeRequest;
        if (request.getFieldNames().size() == 1) {
            String fieldName = (String)request.getFieldNames().iterator().next();
            PlcField field = request.getField(fieldName);
            ModbusPDU requestPdu = this.getWriteRequestPdu(field, ((DefaultPlcWriteRequest)writeRequest).getPlcValue(fieldName));
            int transactionIdentifier = this.transactionIdentifierGenerator.getAndIncrement();
            ModbusTcpADU modbusTcpADU = new ModbusTcpADU(transactionIdentifier, this.unitIdentifier, requestPdu);
            RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
            transaction.submit(() -> this.context.sendRequest((Object)modbusTcpADU).expectResponse(ModbusTcpADU.class, this.requestTimeout).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).check(p -> p.getTransactionIdentifier() == transactionIdentifier).unwrap(ModbusTcpADU::getPdu).handle(responsePdu -> {
                Object plcValue = null;
                PlcResponseCode responseCode = PlcResponseCode.OK;
                DefaultPlcWriteResponse response = new DefaultPlcWriteResponse((InternalPlcWriteRequest)request, Collections.singletonMap(fieldName, responseCode));
                future.complete((PlcWriteResponse)response);
                transaction.endRequest();
            }));
        } else {
            future.completeExceptionally((Throwable)new PlcRuntimeException("Modbus only supports single filed requests"));
        }
        return future;
    }

    private ModbusPDU getReadRequestPdu(PlcField field) {
        if (field instanceof ModbusFieldDiscreteInput) {
            ModbusFieldDiscreteInput discreteInput = (ModbusFieldDiscreteInput)field;
            return new ModbusPDUReadDiscreteInputsRequest(discreteInput.getAddress(), discreteInput.getQuantity());
        }
        if (field instanceof ModbusFieldCoil) {
            ModbusFieldCoil coil = (ModbusFieldCoil)field;
            return new ModbusPDUReadCoilsRequest(coil.getAddress(), coil.getQuantity());
        }
        if (field instanceof ModbusFieldInputRegister) {
            ModbusFieldInputRegister inputRegister = (ModbusFieldInputRegister)field;
            return new ModbusPDUReadInputRegistersRequest(inputRegister.getAddress(), inputRegister.getQuantity());
        }
        if (field instanceof ModbusFieldHoldingRegister) {
            ModbusFieldHoldingRegister holdingRegister = (ModbusFieldHoldingRegister)field;
            return new ModbusPDUReadHoldingRegistersRequest(holdingRegister.getAddress(), holdingRegister.getQuantity());
        }
        throw new PlcRuntimeException("Unsupported read field type " + field.getClass().getName());
    }

    private ModbusPDU getWriteRequestPdu(PlcField field, PlcValue plcValue) {
        if (field instanceof ModbusFieldCoil) {
            ModbusFieldCoil coil = (ModbusFieldCoil)field;
            return new ModbusPDUWriteMultipleCoilsRequest(coil.getAddress(), coil.getQuantity(), this.fromPlcValue(plcValue));
        }
        if (field instanceof ModbusFieldHoldingRegister) {
            ModbusFieldHoldingRegister holdingRegister = (ModbusFieldHoldingRegister)field;
            return new ModbusPDUWriteMultipleHoldingRegistersRequest(holdingRegister.getAddress(), holdingRegister.getQuantity(), this.fromPlcValue(plcValue));
        }
        throw new PlcRuntimeException("Unsupported write field type " + field.getClass().getName());
    }

    private PlcValue toPlcValue(ModbusPDU request, ModbusPDU response) throws ParseException {
        if (request instanceof ModbusPDUReadDiscreteInputsRequest) {
            if (!(response instanceof ModbusPDUReadDiscreteInputsResponse)) {
                throw new PlcRuntimeException("Unexpected response type. Expected ModbusPDUReadDiscreteInputsResponse, but got " + response.getClass().getName());
            }
            ModbusPDUReadDiscreteInputsRequest req = (ModbusPDUReadDiscreteInputsRequest)request;
            ModbusPDUReadDiscreteInputsResponse resp = (ModbusPDUReadDiscreteInputsResponse)response;
            return this.readBooleanList(req.getQuantity(), resp.getValue());
        }
        if (request instanceof ModbusPDUReadCoilsRequest) {
            if (!(response instanceof ModbusPDUReadCoilsResponse)) {
                throw new PlcRuntimeException("Unexpected response type. Expected ModbusPDUReadCoilsResponse, but got " + response.getClass().getName());
            }
            ModbusPDUReadCoilsRequest req = (ModbusPDUReadCoilsRequest)request;
            ModbusPDUReadCoilsResponse resp = (ModbusPDUReadCoilsResponse)response;
            return this.readBooleanList(req.getQuantity(), resp.getValue());
        }
        if (request instanceof ModbusPDUReadInputRegistersRequest) {
            if (!(response instanceof ModbusPDUReadInputRegistersResponse)) {
                throw new PlcRuntimeException("Unexpected response type. Expected ModbusPDUReadInputRegistersResponse, but got " + response.getClass().getName());
            }
            ModbusPDUReadInputRegistersRequest req = (ModbusPDUReadInputRegistersRequest)request;
            ModbusPDUReadInputRegistersResponse resp = (ModbusPDUReadInputRegistersResponse)response;
            ReadBuffer io = new ReadBuffer(resp.getValue());
            return DataItemIO.staticParse(io, (short)2, (short)req.getQuantity());
        }
        if (request instanceof ModbusPDUReadHoldingRegistersRequest) {
            if (!(response instanceof ModbusPDUReadHoldingRegistersResponse)) {
                throw new PlcRuntimeException("Unexpected response type. Expected ModbusPDUReadHoldingRegistersResponse, but got " + response.getClass().getName());
            }
            ModbusPDUReadHoldingRegistersRequest req = (ModbusPDUReadHoldingRegistersRequest)request;
            ModbusPDUReadHoldingRegistersResponse resp = (ModbusPDUReadHoldingRegistersResponse)response;
            ReadBuffer io = new ReadBuffer(resp.getValue());
            return DataItemIO.staticParse(io, (short)2, (short)req.getQuantity());
        }
        return null;
    }

    private byte[] fromPlcValue(PlcValue plcValue) {
        if (plcValue instanceof PlcList) {
            PlcList plcList = (PlcList)plcValue;
            BitSet booleans = null;
            ArrayList<Short> shorts = null;
            int b = 0;
            for (PlcValue value : plcList.getList()) {
                if (value instanceof PlcBoolean) {
                    if (booleans == null) {
                        booleans = new BitSet(plcList.getList().size());
                    }
                    PlcBoolean plcBoolean = (PlcBoolean)value;
                    booleans.set(b, plcBoolean.getBoolean());
                    ++b;
                    continue;
                }
                if (value.isShort()) {
                    if (shorts == null) {
                        shorts = new ArrayList<Short>(plcList.getList().size());
                    }
                    shorts.add(value.getShort());
                    continue;
                }
                throw new PlcRuntimeException("Can only encode boolean or short values");
            }
            if (booleans != null) {
                return booleans.toByteArray();
            }
            if (shorts != null) {
                byte[] bytes = new byte[shorts.size() * 2];
                for (int i = 0; i < shorts.size(); ++i) {
                    Short shortValue = (Short)shorts.get(i);
                    bytes[i * 2] = (byte)(shortValue >> 8 & 0xFF);
                    bytes[i * 2 + 1] = (byte)(shortValue & 0xFF);
                }
                return bytes;
            }
        } else {
            if (plcValue instanceof PlcBoolean) {
                byte[] byArray;
                PlcBoolean plcBoolean = (PlcBoolean)plcValue;
                if (plcBoolean.getBoolean()) {
                    byte[] byArray2 = new byte[1];
                    byArray = byArray2;
                    byArray2[0] = 1;
                } else {
                    byte[] byArray3 = new byte[1];
                    byArray = byArray3;
                    byArray3[0] = 0;
                }
                return byArray;
            }
            if (plcValue instanceof PlcShort) {
                PlcShort plcShort = (PlcShort)plcValue;
                Short shortValue = plcShort.getShort();
                byte[] bytes = new byte[]{(byte)(shortValue >> 8 & 0xFF), (byte)(shortValue & 0xFF)};
                return bytes;
            }
        }
        return new byte[0];
    }

    private PlcValue readBooleanList(int count, byte[] data) throws ParseException {
        ReadBuffer io = new ReadBuffer(data);
        if (count == 1) {
            return DataItemIO.staticParse(io, (short)1, (short)1);
        }
        BitSet bits = BitSet.valueOf(data);
        ArrayList<PlcBoolean> result = new ArrayList<PlcBoolean>(count);
        for (int i = 0; i < count; ++i) {
            result.add(new PlcBoolean(bits.get(i)));
        }
        return new PlcList(result);
    }
}

