/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.field;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.value.PlcBoolean;
import org.apache.plc4x.java.api.value.PlcList;
import org.apache.plc4x.java.api.value.PlcShort;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.modbus.field.ModbusField;
import org.apache.plc4x.java.modbus.field.ModbusFieldCoil;
import org.apache.plc4x.java.modbus.field.ModbusFieldDiscreteInput;
import org.apache.plc4x.java.modbus.field.ModbusFieldHoldingRegister;
import org.apache.plc4x.java.modbus.field.ModbusFieldInputRegister;
import org.apache.plc4x.java.spi.connection.DefaultPlcFieldHandler;

public class ModbusFieldHandler
extends DefaultPlcFieldHandler {
    public PlcField createField(String fieldQuery) throws PlcInvalidFieldException {
        if (ModbusFieldDiscreteInput.matches(fieldQuery)) {
            return ModbusFieldDiscreteInput.of(fieldQuery);
        }
        if (ModbusFieldHoldingRegister.matches(fieldQuery)) {
            return ModbusFieldHoldingRegister.of(fieldQuery);
        }
        if (ModbusFieldInputRegister.matches(fieldQuery)) {
            return ModbusFieldInputRegister.of(fieldQuery);
        }
        if (ModbusFieldCoil.matches(fieldQuery)) {
            return ModbusFieldCoil.of(fieldQuery);
        }
        throw new PlcInvalidFieldException(fieldQuery);
    }

    public PlcValue encodeBoolean(PlcField field, Object[] values) {
        ModbusField modbusField = (ModbusField)field;
        LinkedList<Boolean> booleanValues = new LinkedList<Boolean>();
        for (Object value : values) {
            BitSet bitSet;
            if (value instanceof Boolean) {
                Boolean booleanValue = (Boolean)value;
                booleanValues.add(booleanValue);
                continue;
            }
            if (value instanceof Byte) {
                Byte byteValue = (Byte)value;
                bitSet = BitSet.valueOf(new byte[]{byteValue});
                for (int i = 0; i < 8; ++i) {
                    booleanValues.add(bitSet.get(i));
                }
                continue;
            }
            if (value instanceof Short) {
                Short shortValue = (Short)value;
                bitSet = BitSet.valueOf(new long[]{shortValue.shortValue()});
                for (int i = 0; i < 16; ++i) {
                    booleanValues.add(bitSet.get(i));
                }
                continue;
            }
            if (value instanceof Integer) {
                Integer integerValue = (Integer)value;
                bitSet = BitSet.valueOf(new long[]{integerValue.intValue()});
                for (int i = 0; i < 32; ++i) {
                    booleanValues.add(bitSet.get(i));
                }
                continue;
            }
            if (value instanceof Long) {
                long longValue = (Long)value;
                BitSet bitSet2 = BitSet.valueOf(new long[]{longValue});
                for (int i = 0; i < 64; ++i) {
                    booleanValues.add(bitSet2.get(i));
                }
                continue;
            }
            throw new IllegalArgumentException("Value of type " + value.getClass().getName() + " is not assignable to " + modbusField + " fields.");
        }
        if (booleanValues.size() == 1) {
            return new PlcBoolean((Boolean)booleanValues.get(0));
        }
        return new PlcList(booleanValues);
    }

    public PlcValue encodeByte(PlcField field, Object[] values) {
        return this.encodeShort(field, values);
    }

    public PlcValue encodeInteger(PlcField field, Object[] values) {
        return this.encodeShort(field, values);
    }

    public PlcValue encodeLong(PlcField field, Object[] values) {
        return this.encodeShort(field, values);
    }

    public PlcValue encodeBigInteger(PlcField field, Object[] values) {
        return this.encodeShort(field, values);
    }

    public PlcValue encodeFloat(PlcField field, Object[] values) {
        return this.encodeShort(field, values);
    }

    public PlcValue encodeDouble(PlcField field, Object[] values) {
        return this.encodeShort(field, values);
    }

    public PlcValue encodeBigDecimal(PlcField field, Object[] values) {
        return this.encodeShort(field, values);
    }

    public PlcValue encodeShort(PlcField field, Object[] values) {
        if (values.length == 1) {
            Number numberValue = (Number)values[0];
            if (numberValue.intValue() < Short.MIN_VALUE || numberValue.intValue() > Short.MAX_VALUE) {
                throw new PlcInvalidFieldException("Value of " + numberValue.toString() + " exceeds the boundaries of a short value.");
            }
            return new PlcShort(numberValue.shortValue());
        }
        ArrayList<PlcShort> shorts = new ArrayList<PlcShort>(values.length);
        for (Object value : values) {
            Number numberValue = (Number)value;
            if (numberValue.intValue() < Short.MIN_VALUE || numberValue.intValue() > Short.MAX_VALUE) {
                throw new PlcInvalidFieldException("Value of " + numberValue.toString() + " exceeds the boundaries of a short value.");
            }
            shorts.add(new PlcShort(((Number)value).shortValue()));
        }
        return new PlcList(shorts);
    }
}

