/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.field;

import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.modbus.field.ModbusFieldCoil;
import org.apache.plc4x.java.modbus.field.ModbusFieldDiscreteInput;
import org.apache.plc4x.java.modbus.field.ModbusFieldHoldingRegister;
import org.apache.plc4x.java.modbus.field.ModbusFieldInputRegister;

public abstract class ModbusField
implements PlcField {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("(?<address>\\d+)(\\[(?<quantity>\\d+)])?");
    public static final Pattern FIXED_DIGIT_MODBUS_PATTERN = Pattern.compile("(?<address>\\d{4,5})(\\[(?<quantity>\\d+)])?");
    protected static final int PROTOCOL_ADDRESS_OFFSET = 1;
    private final int address;
    private final int quantity;

    public static ModbusField of(String addressString) throws PlcInvalidFieldException {
        if (ModbusFieldCoil.matches(addressString)) {
            return ModbusFieldCoil.of(addressString);
        }
        if (ModbusFieldDiscreteInput.matches(addressString)) {
            return ModbusFieldDiscreteInput.of(addressString);
        }
        if (ModbusFieldHoldingRegister.matches(addressString)) {
            return ModbusFieldHoldingRegister.of(addressString);
        }
        if (ModbusFieldInputRegister.matches(addressString)) {
            return ModbusFieldInputRegister.of(addressString);
        }
        throw new PlcInvalidFieldException("Unable to parse address: " + addressString);
    }

    protected ModbusField(int address, Integer quantity) {
        this.address = address;
        if (this.address + 1 <= 0) {
            throw new IllegalArgumentException("address must be greater then zero. Was " + (this.address + 1));
        }
        int n = this.quantity = quantity != null ? quantity : 1;
        if (this.quantity <= 0) {
            throw new IllegalArgumentException("quantity must be greater then zero. Was " + this.quantity);
        }
    }

    public int getAddress() {
        return this.address;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusField)) {
            return false;
        }
        ModbusField that = (ModbusField)o;
        return this.address == that.address;
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }

    public String toString() {
        return "ModbusField{address=" + this.address + "quantity=" + this.quantity + '}';
    }
}

